% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facebook.R
\name{fb_report_check}
\alias{fb_report_check}
\title{Facebook API Report Status Check}
\usage{
fb_report_check(
  token,
  report_run_id,
  api_version = NULL,
  live = FALSE,
  sleep = 10,
  quiet = FALSE
)
}
\arguments{
\item{token}{Character. Valid access token with sufficient privileges. Visit the
\href{https://developers.facebook.com/tools/explorer}{Facebook API Graph Explorer}
to acquire one.}

\item{report_run_id}{Integer. Report ID to check status.}

\item{api_version}{Character. Facebook API version.}

\item{live}{Boolean. Run until status report is finished?}

\item{sleep}{Boolean. If \code{live=TRUE}, then how many seconds should
we wait until next check?}

\item{quiet}{Boolean. Keep quiet? If not, informative messages will be shown.}
}
\value{
List with API status results.
}
\description{
This returns all available FB insights per day including any given
breakdown to the specified report level, and place into a data frame.
For more information on Ad Insights' API, go to the original
\href{https://developers.facebook.com/docs/marketing-api/insights/}{documentaion}.
}
\examples{
\dontrun{
token <- "YOURTOKEN"
report_run_id <- "123456789"
fb_report_check(token, report_run_id, live = TRUE, quiet = FALSE)
}
}
\seealso{
Other API: 
\code{\link{bring_api}()},
\code{\link{fb_accounts}()},
\code{\link{fb_ads}()},
\code{\link{fb_creatives}()},
\code{\link{fb_insights}()},
\code{\link{fb_process}()},
\code{\link{fb_rf}()},
\code{\link{fb_token}()},
\code{\link{gemini_ask}()},
\code{\link{gpt_ask}()},
\code{\link{queryGA}()},
\code{\link{slackSend}()}

Other Meta: 
\code{\link{fb_accounts}()},
\code{\link{fb_ads}()},
\code{\link{fb_creatives}()},
\code{\link{fb_insights}()},
\code{\link{fb_process}()},
\code{\link{fb_rf}()},
\code{\link{fb_token}()}
}
\concept{API}
\concept{Meta}
