% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{process_y_functional}
\alias{process_y_functional}
\title{Process Outcome Input for Keras (Functional API)}
\usage{
process_y_functional(y, is_classification = NULL, class_levels = NULL)
}
\arguments{
\item{y}{A vector or data frame of outcomes.}

\item{is_classification}{Logical, optional. If \code{TRUE}, treats \code{y} as
classification. If \code{FALSE}, treats as regression. If \code{NULL} (default),
it's determined from \code{is.factor(y)}.}

\item{class_levels}{Character vector, optional. The factor levels for
classification outcomes. If \code{NULL} (default), determined from \code{levels(y)}.}
}
\value{
A list containing:
\itemize{
\item \code{y_proc}: The processed outcome data (matrix or one-hot encoded array,
or list of these for multiple outputs).
\item \code{is_classification}: Logical, indicating if \code{y} was treated as classification.
\item \code{num_classes}: Integer, the number of classes for classification, or \code{NULL}.
\item \code{class_levels}: Character vector, the factor levels for classification, or \code{NULL}.
}
}
\description{
Preprocesses outcome data (\code{y}) into a format suitable for Keras models
built with the Functional API. Handles both regression (numeric) and
classification (factor) outcomes, including one-hot encoding for classification,
and supports multiple outputs.
}
\keyword{internal}
