% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-wrappers.R
\name{time_distributed}
\alias{time_distributed}
\title{Apply a layer to every temporal slice of an input.}
\usage{
time_distributed(object, layer, input_shape = NULL,
  batch_input_shape = NULL, batch_size = NULL, dtype = NULL,
  name = NULL, trainable = NULL, weights = NULL)
}
\arguments{
\item{object}{Model or layer object}

\item{layer}{A layer instance.}

\item{input_shape}{Dimensionality of the input (integer) not including the
samples axis. This argument is required when using this layer as the first
layer in a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
The input should be at least 3D, and the dimension of index one will be
considered to be the temporal dimension.
}
\details{
Consider a batch of 32 samples,  where each sample is a sequence of 10 vectors of 16 dimensions. The batch
input shape of the layer is then \code{(32, 10, 16)}, and the \code{input_shape}, not
including the samples dimension, is \code{(10, 16)}. You can then use
\code{time_distributed} to apply a \code{layer_dense} to each of the 10 timesteps,
independently.
}
\seealso{
Other layer wrappers: \code{\link{bidirectional}}
}
