% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{callback_reduce_lr_on_plateau}
\alias{callback_reduce_lr_on_plateau}
\title{Reduce learning rate when a metric has stopped improving.}
\usage{
callback_reduce_lr_on_plateau(monitor = "val_loss", factor = 0.1,
  patience = 10, verbose = 0, mode = c("auto", "min", "max"),
  epsilon = 1e-04, cooldown = 0, min_lr = 0)
}
\arguments{
\item{monitor}{quantity to be monitored.}

\item{factor}{factor by which the learning rate will be reduced. new_lr = lr
\itemize{
\item factor
}}

\item{patience}{number of epochs with no improvement after which learning
rate will be reduced.}

\item{verbose}{int. 0: quiet, 1: update messages.}

\item{mode}{one of "auto", "min", "max". In min mode, lr will be reduced when
the quantity monitored has stopped decreasing; in max mode it will be
reduced when the quantity monitored has stopped increasing; in auto mode,
the direction is automatically inferred from the name of the monitored
quantity.}

\item{epsilon}{threshold for measuring the new optimum, to only focus on
significant changes.}

\item{cooldown}{number of epochs to wait before resuming normal operation
after lr has been reduced.}

\item{min_lr}{lower bound on the learning rate.}
}
\description{
Models often benefit from reducing the learning rate by a factor of 2-10 once
learning stagnates. This callback monitors a quantity and if no improvement
is seen for a 'patience' number of epochs, the learning rate is reduced.
}
\seealso{
Other callbacks: \code{\link{callback_csv_logger}},
  \code{\link{callback_early_stopping}},
  \code{\link{callback_lambda}},
  \code{\link{callback_learning_rate_scheduler}},
  \code{\link{callback_model_checkpoint}},
  \code{\link{callback_progbar_logger}},
  \code{\link{callback_remote_monitor}},
  \code{\link{callback_tensorboard}},
  \code{\link{callback_terminate_on_naan}}
}
