% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kanji1.R
\name{plotkanji}
\alias{plotkanji}
\title{Plot kanji}
\usage{
plotkanji(
  kanji,
  device = "default",
  family = NULL,
  factor = 10,
  width = NULL,
  height = NULL,
  ...
)
}
\arguments{
\item{kanji}{a vector of class character specifying one or several kanji to be plotted.}

\item{device}{the type of graphics device where the kanji is plotted. Defaults to the
user's default type according to \code{getOption("device")}.}

\item{family}{the font family or families used for writing the kanji. Make sure to add the font(s)
first by using \code{\link[sysfonts]{font_add}}; see details. If \code{family} is
a vector of several font families they are matched to the characters in \code{kanji}
(and possibly recycled).}

\item{factor}{a maginification factor applied to the font size (typically 12 points).}

\item{width, height}{the dimensions of the device.}

\item{...}{further parameters passed to the function opening the device (such as a
file name for devices that create a file).}
}
\value{
No return value, called for side effects.
}
\description{
Write kanji to a graphics device.
}
\details{
This function writes one or several kanji to a graphics device
in an arbitrary font that has been registered, i.e., added
to the database in package \code{sysfonts}. For the latter say \code{\link[sysfonts]{font_add}} or
\code{\link[sysfonts]{font_families}} to verify what fonts are available.

For further information see \emph{Working with Japanese fonts} in \code{vignette("kanjistat", package = "kanjistat")}.
\code{plotkanji} uses the package \code{showtext} to write the kanji in a large font at the
center of a new device of the specified type.
specify \code{device = "current"} to write the kanji to the current device. It is now recommended
to simply use \code{graphics::text} in combination with \code{showtext::showtext_auto} instead.
}
\section{Warning}{

If no font family is provided, the default \strong{Chinese} font WenQuanYi Micro Hei that comes with the package showtext is used.
This means that the characters will typically be recognizable, but quite often look odd as Japanese characters.
We strongly advised that a Japanese font is used as detailed above.
}

\examples{
plotkanji("\u6edd")   
plotkanji("\u72ac\u732b\u9b5a")

}
