% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_gamma.R
\name{gamma_pred}
\alias{gamma_pred}
\title{gamma_pred}
\usage{
gamma_pred(conj.param, outcome = NULL, parms = list(), pred.cred = 0.95)
}
\arguments{
\item{conj.param}{list or data.frame: The parameters of the conjugated distributions of the linear predictor.}

\item{outcome}{numeric or matrix (optional): The observed values at the current time. Not used in this function.}

\item{parms}{list: A list of extra parameters for the model. For this function, it must contain the shape parameter phi of the observational model.}

\item{pred.cred}{numeric: the desired credibility for the credibility interval.}
}
\value{
A list containing the following values:
\itemize{
   \item pred numeric/matrix: the mean of the predictive distribution of a next observation. Same type and shape as the parameter in model.
   \item var.pred numeric/matrix: the variance of the predictive distribution of a next observation. Same type and shape as the parameter in model.
   \item icl.pred numeric/matrix: the percentile of 100*((1-pred.cred)/2)% of the predictive distribution of a next observation. Same type and shape as the parameter in model.
   \item icu.pred numeric/matrix: the percentile of 100*(1-(1-pred.cred)/2)% of the predictive distribution of a next observation. Same type and shape as the parameter in model.
   \item log.like numeric: the The log likelihood for the outcome given the conjugated parameters.
}
}
\description{
Calculate the values for the predictive distribution given the values of the parameter of the conjugated distribution of the linear predictor.
The data is assumed to have Gamma distribution with known shape parameter phi and its mean having distribution Inverse-Gamma with shape parameter a e rate parameter b.
In this scenario, the marginal distribution of the data is Beta prime with parameters phi, alpha, beta / phi.
}
\seealso{
Other auxiliary functions for a Gamma outcome with known shape: 
\code{\link{convert_Gamma_Normal}()},
\code{\link{convert_Normal_Gamma}()},
\code{\link{update_Gamma}()}
}
\concept{auxiliary functions for a Gamma outcome with known shape}
\keyword{internal}
