% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jjcsformats.R
\name{jjcsformat_pval_fct}
\alias{jjcsformat_pval_fct}
\title{Function factory for p-value formatting}
\usage{
jjcsformat_pval_fct(alpha = 0.05)
}
\arguments{
\item{alpha}{\code{number}\cr the significance level to account for during rounding.}
}
\value{
The p-value in the standard format. If \code{count} is 0, the format is \code{0}.
If it is smaller than 0.001, then \verb{<0.001}, if it is larger than 0.999, then
\verb{>0.999} is returned. Otherwise, 3 digits are used. In the special case that
rounding from below would make the string equal to the specified \code{alpha},
then a higher number of digits is used to be able to still see the difference.
For example, 0.0048 is not rounded to 0.005 but stays at 0.0048 if \code{alpha = 0.005}
is set.
}
\description{
A function factory to generate formatting functions for p-value
formatting that support rounding close to the significance level specified
}
\examples{
my_pval_format <- jjcsformat_pval_fct(0.005)
my_pval_format(0.2802359)
my_pval_format(0.0048)
my_pval_format(0.00499)
my_pval_format(0.004999999)
my_pval_format(0.0051)
my_pval_format(0.0009)
my_pval_format(0.9991)

}
\seealso{
Other JJCS formats: 
\code{\link{count_fraction}},
\code{\link{format_xx_fct}()},
\code{\link{jjcsformat_range_fct}()}
}
\concept{JJCS formats}
