% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survst.R
\name{survst}
\alias{survst}
\title{Function for survival starting values}
\usage{
survst(survdat, surv.formula, survdat2, strat, study.name = NULL)
}
\arguments{
\item{survdat}{the survival data with factors and interaction terms expanded,
ordered by increasing survival time}

\item{surv.formula}{a formula object with the survival time, censoring
indicator and the covariates to include in the survival sub-model.  The
response must be a survival object as returned by the
\code{\link[survival]{Surv}} function.}

\item{survdat2}{the survival data with original variables (factors and
interaction terms not expanded), ordered by increasing survival time}

\item{strat}{logical value: if \code{TRUE} then the survival sub-model is
calculated with a baseline stratified by study.  Otherwise baseline is
unstratified}

\item{study.name}{a character string denoting the name of the variable in the
baseline dataset in \code{data} holding study membership, for example
\code{study.name = 'study'}.}
}
\value{
A list of the results from the initial survival fit is returned. This
  list contains the following elements: \describe{

  \item{\code{beta2}}{a vector of the estimated coefficients for fixed
  effects included in the survival sub-model. If there are no fixed effects
  included in the survival sub-model then this returns \code{NULL}}.

  \item{\code{haz}}{the estimate of the baseline hazard estimated from the
  separate survival model.  If \code{strat = TRUE} then this is a list of
  length equal to the number of studies in the dataset, each element of which
  is a vector of length equal to the number of events in each study. If
  \code{strat = FALSE} then this is a vector of length equal to the number of
  events in the entire dataset.}

  \item{\code{rs}}{the number of events that have occured by the individual
  in question's survival time. If \code{strat = TRUE} then this is a list of
  length equal to the number of studies in the dataset, each element of which
  is a vector of length equal to the number of individuals in each study. If
  \code{strat = FALSE} then this is a vector of length equal to the number of
  individuals in the entire dataset.}

  \item{\code{sf}}{the survival times where at least one event was observed.
  If \code{strat = TRUE} then this is a list of length equal to the number of
  studies in the dataset, each element of which is a vector of length equal
  to the number of events in each study. If \code{strat = FALSE} then this is
  a vector of length equal to the number of events in the entire dataset.}

  \item{\code{nev}}{the number of events that occur at each unique event
  time.  If \code{strat = TRUE} then this is a list of length equal to the
  number of studies in the dataset, each element of which is a vector of
  length equal to the number of events in each study. If \code{strat = FALSE}
  then this is a vector of length equal to the number of events in the entire
  dataset.}

  \item{\code{log.like.surv}}{the value of the log-likelihood from the
  separate survival analysis}

  \item{\code{modelfit}}{the initial survival model fit, fitted using the
  \code{\link[survival]{coxph}} function from the
  \code{survival} package.}

  }
}
\description{
Internal function to estimate the starting values for the EM algorithm for
the survival sub-model
}
\keyword{internal}
