% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructWeights.R
\name{constructWeights}
\alias{constructWeights}
\title{Construct weights for _jewel_ minimization problem from prior information on vertices degrees.}
\usage{
constructWeights(d, K = NULL)
}
\arguments{
\item{d}{either one numerical vector or a list of \code{K} numerical vectors 
of length \code{p} with user-provided degrees of vertices for each class. 
If there is only one vector, we assume degrees are the same for all \code{K} classes. 
In that case parameter \code{K} (number of classes) must be provided.
Note that for successful _jewel_ estimation true degrees are not necessary: 
for example, user can provide a vector where known hubs have degree 10 
and the rest of the vertices have degree 1.}

\item{K}{number of classes (i.e. datasets, i.e. desired graphs). By default it is length(d).
In length(d) = 1, \code{K} must be provided by the user.}
}
\value{
W - a list of \code{K} numeric matrices of the size \code{p} by \code{p}
}
\description{
Function takes a numerical vector of vertices degrees and constructs weights with the rule \code{W_ij = 1 / sqrt(d_i * d_j)} and then the whole matrix is normilized by the maximum.
}
\examples{
{
K <- 3
p <- 50
n <- 20
data <- generateData_rewire(K = K, p = p, n = n, ncores = 1, verbose = FALSE)
G_list_true <- data$Graphs
true_degrees <- rowSums(G_list_true[[1]])
cut <- sort(true_degrees, decreasing = TRUE)[ceiling(p * 0.03)]
apriori_hubs <- ifelse(true_degrees >= cut, 10, 1)
W <- constructWeights(apriori_hubs, K = K)
}
}
