% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_cat.R
\name{parallel_cat}
\alias{parallel_cat}
\title{Parallel Coordinates Category}
\usage{
parallel_cat(
  irace_results,
  id_configurations = NULL,
  param_names = NULL,
  iterations = NULL,
  by_n_param = NULL,
  n_bins = 3,
  filename = NULL
)
}
\arguments{
\item{irace_results}{The data generated when loading the \code{.Rdata} file created by \code{irace} (or the filename of that file).}

\item{id_configurations}{Configuration ids to be included in the
plot. Example: \code{c(20,50,100,300,500,600,700)}}

\item{param_names}{(\code{character()}) Parameters to be included in the plot. Example:
\code{c("algorithm","alpha","rho","q0","rasrank")}.}

\item{iterations}{Numeric vector, iterations from which configuration should be obtained
(example: iterations = c(1,4,5))}

\item{by_n_param}{Numeric (optional), maximum number of parameters to be displayed.}

\item{n_bins}{Numeric (default 3), number of intervals to generate for numerical parameters.}

\item{filename}{(\code{character(1)}) File name to save the plot, for example \code{"~/path/example/filename.png"}.}
}
\value{
parallel categories plot
}
\description{
Parallel categories plot of selected configurations.  Numerical parameters
are discretized to maximum \code{n_bins} intervals.  To visualize configurations
of other iterations these must be provided setting the argument iterations,
groups of configurations of different iterations are shown in different
colors. Specific configurations can be selected providing their ids in the
\code{id_configurations} argument.
}
\details{
The parameters to be included in the plot can be selected with the
param_names argument. Additionally, the maximum number of parameters to be
displayed in one plot. A list of plots is returned by this function in
several plots are required to display the selected data.
}
\examples{
iraceResults <- read_logfile(system.file(package="irace", "exdata",
                                         "irace-acotsp.Rdata", mustWork = TRUE))
parallel_cat(iraceResults)
\donttest{ 
parallel_cat(iraceResults, by_n_param = 6)
parallel_cat(iraceResults, id_configurations = c(20, 50, 100))
parallel_cat(iraceResults, param_names = c("algorithm", "alpha", "rho", "q0", "rasrank"))
parallel_cat(iraceResults, iterations = c(1, 4, 6), n_bins=4)
}
}
\seealso{
\code{\link[=parallel_coord]{parallel_coord()}} \code{\link[=plot_configurations]{plot_configurations()}}
}
