% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iota_version_2.R
\name{get_iota2_measures}
\alias{get_iota2_measures}
\title{Get Iota2 Measures}
\usage{
get_iota2_measures(aem, categorical_sizes, categorical_levels)
}
\arguments{
\item{aem}{Assignment Error Matrix.}

\item{categorical_sizes}{Probabilities for the different categories to occur.}

\item{categorical_levels}{\code{Vector} containing all possible categories of
the content analysis.}
}
\value{
Returns a \code{list} of all measures belonging to the Iota Concept
of the second generation.
The first component \code{estimates_categorical_level} comprises all
elements that describe the ratings on a categorical level. The elements are
sub-divided into raw estimates and chance-corrected estimates.
\describe{
\item{\code{raw_estimates}}{
\describe{
\item{\code{iota: }}{A vector containing the Iota values for each category.}
 \item{\code{iota_error_1: }}{A vector containing the Iota Error Type I values for each category.}
 \item{\code{iota_error_2: }}{A vector containing the Iota Error Type II values for each category.}
\item{\code{alpha_reliability: }}{A vector containing the Alpha
Reliabilities for each category. These values represent probabilities.}
\item{\code{beta_reliability: }}{A vector containing the Beta Reliabilities for each
category. These values represent probabilities.}
\item{\code{assignment_error_matrix: }}{Assignment Error Matrix containing the conditional
probabilities for assigning a unit of category i to categories 1 to n.}
}}
\item{\code{elements_chance_corrected}}{
\describe{
\item{\code{alpha_reliability: }}{A vector containing the chance-corrected Alpha Reliabilities for each category.}
\item{\code{beta_reliability: }}{A vector containing the chance-corrected Beta Reliabilities for each category.}
}}
}
The second component \code{estimates_scale_level} contains elements for
describing the quality of the ratings on a scale level. It comprises the
following elements:
\describe{
\item{\code{iota_index: }}{The Iota Index, representing the reliability on a scale level.}
\item{\code{iota_index_d4: }}{The Static Iota Index, which is a transformation of the original Iota Index,
in order to consider the uncertainty of estimation.}
\item{\code{iota_index_dyn2: }}{The Dynamic Iota Index, which is a transformation of the original Iota Index,
in order to consider the uncertainty of estimation.}
}
}
\description{
Function for calculating the elements of the Iota Concept 2
}
\references{
Florian Berding and Julia Pargmann (2022).Iota Reliability Concept
of the Second Generation. Measures for Content Analysis Done by
Humans or Artificial Intelligences. Berlin: Logos.
https://doi.org/10.30819/5581
}
