% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaIC.R
\name{deltaIC}
\alias{deltaIC}
\title{Summarise DIC and WAIC from \code{lgcp} objects.}
\usage{
deltaIC(..., criterion = "DIC")
}
\arguments{
\item{...}{Comma-separated objects inheriting from class \code{inla} and obtained
from a run of \code{INLA::inla()}, \code{\link[=bru]{bru()}} or \code{\link[=lgcp]{lgcp()}}}

\item{criterion}{character vector.
If it includes 'DIC', computes DIC differences;
If it contains 'WAIC', computes WAIC differences. Default: 'DIC'}
}
\value{
A data frame with each row containing the Model name,
DIC and Delta.DIC, and/or WAIC and Delta.WAIC.
}
\description{
Calculates DIC and/or WAIC differences and produces an ordered summary.
}
\examples{
\donttest{
if (bru_safe_inla()) {
  # Generate some data
  input.df <- data.frame(idx = 1:10, x = cos(1:10))
  input.df <- within(
    input.df,
    y <- rpois(10, 5 + 2 * cos(1:10) + rnorm(10, mean = 0, sd = 0.1))
  )

  # Fit two models
  fit1 <- bru(
    y ~ x,
    family = "poisson",
    data = input.df,
    options = list(control.compute = list(dic = TRUE))
  )
  fit2 <- bru(
    y ~ x + rand(idx, model = "iid"),
    family = "poisson",
    data = input.df,
    options = list(control.compute = list(dic = TRUE))
  )

  # Compare DIC

  deltaIC(fit1, fit2)
}
}
}
