% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment.R
\name{bru_log_message}
\alias{bru_log_message}
\title{Add a log message}
\usage{
bru_log_message(
  ...,
  domain = NULL,
  appendLF = TRUE,
  verbosity = 1L,
  allow_verbose = TRUE,
  verbose = NULL,
  verbose_store = NULL,
  x = NULL
)
}
\arguments{
\item{...}{For \code{bru_log_message()}, zero or more objects passed on to
\code{\link[base:message]{base::.makeMessage()}}}

\item{domain}{Domain for translations, passed on to \code{\link[base:message]{base::.makeMessage()}}}

\item{appendLF}{logical; whether to add a newline to the message. Only
used for verbose output.}

\item{verbosity}{numeric value describing the verbosity level of the message}

\item{allow_verbose}{Whether to allow verbose output. Must be set to FALSE
until the options object has been initialised.}

\item{verbose}{logical, numeric, or \code{NULL}; local override for verbose
output. If \code{NULL}, the global option \code{bru_verbose} or default value is used.
If \code{FALSE}, no messages are printed. If \code{TRUE}, messages with \code{verbosity}
\eqn{\le 1}{<=1}
are printed. If numeric, messages with \code{verbosity} \eqn{\le}{<=} \code{verbose}
are printed.}

\item{verbose_store}{Same as \code{verbose}, but controlling what messages are
stored in the global log object. Can be controlled via the
\code{bru_verbose_store} with \code{\link[=bru_options_set]{bru_options_set()}}.}

\item{x}{A \code{bru_log} object. If \code{NULL}, refers to the global \code{inlabru} log.}
}
\value{
\code{bru_log_message} returns \code{invisible(x)}, where \code{x} is the updated \code{bru_log}
object, or \code{NULL}.
}
\description{
Adds a log message.
}
\examples{
if (interactive()) {
  code_runner <- function() {
    local_bru_options_set(
      # Show messages up to and including level 2 (default 0)
      bru_verbose = 2,
      # Store messages to an including level 3 (default Inf, storing all)
      bru_verbose_store = 3
    )

    bru_log_bookmark("bookmark 1")
    bru_log_message("Test message 1", verbosity = 1)
    bru_log_message("Test message 2", verbosity = 2)
    bru_log_bookmark("bookmark 2")
    bru_log_message("Test message 3", verbosity = 3)
    bru_log_message("Test message 4", verbosity = 4)

    invisible()
  }
  message("Run code")
  code_runner()
  message("Check log from bookmark 1")
  print(bru_log()["bookmark 1"])
  message("Check log from bookmark 2")
  print(bru_log()["bookmark 2"])
}
}
\seealso{
Other inlabru log methods: 
\code{\link{bru_log}()},
\code{\link{bru_log_bookmark}()},
\code{\link{bru_log_new}()},
\code{\link{bru_log_offset}()},
\code{\link{bru_log_reset}()}
}
\concept{inlabru log methods}
