% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.inference.R
\name{bru_index}
\alias{bru_index}
\alias{bru_index.bru_like}
\alias{bru_index.bru}
\title{Extract predictor index information}
\usage{
bru_index(object, ...)

\method{bru_index}{bru_like}(object, what = NULL, ...)

\method{bru_index}{bru}(object, tag = NULL, what = NULL, ...)
}
\arguments{
\item{object}{A \code{\link[=bru]{bru()}} or \code{\link[=bru_obs]{bru_obs()}} output object}

\item{\dots}{Arguments passed on to sub-methods.}

\item{what}{\code{character} or \code{NULL}; One of \code{NULL}, "all", "observed", and
"missing". If \code{NULL} (default) or "all", gives the index vector for the
full sub-model predictor. If "observed", gives the index vector for the
observed part (response is not \code{NA}). If "missing", gives the index vector
for the missing part (response is \code{NA}) of the model.}

\item{tag}{\code{character} or \code{integer}; Either a character vector identifying
the tags of one or more of the \code{\link[=bru_obs]{bru_obs()}} observation models, or an
integer vector identifying models by their \code{\link[=bru]{bru()}} specification order. If
\code{NULL} (default) computes indices for all sub-models.}
}
\value{
An \code{integer} vector.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Extract the index vector for a \code{\link[=bru_obs]{bru_obs()}} predictor,
or the whole or a subset of a full \code{\link[=bru]{bru()}} predictor.
}
\section{Methods (by class)}{
\itemize{
\item \code{bru_index(bru_like)}: Extract the index vector for the predictor vector for a
\code{\link[=bru_obs]{bru_obs()}} sub-model. The indices are relative to the sub-model, and need
to be appropriately offset to be used in the full model predictor.

\item \code{bru_index(bru)}: Extract the index vector for "APredictor" for one or
more specified observation \code{\link[=bru_obs]{bru_obs()}} sub-models. Accepts any combination
of \code{tag} and \code{what}.

}}
\examples{
\dontshow{if (bru_safe_inla()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
fit <- bru(
  ~ 0 + x,
  bru_obs(
    y ~ .,
    data = data.frame(x = 1:3, y = 1:3 + rnorm(3)),
    tag = "A"
  ),
  bru_obs(
    y ~ .,
    data = data.frame(x = 1:4, y = c(NA, NA, 3:4) + rnorm(4)),
    tag = "B"
  )
)
bru_index(fit)
bru_index(fit, "A")
bru_index(fit, "B")
bru_index(fit, c("B", "A"))
bru_index(fit, what = "missing")
\dontshow{\}) # examplesIf}
}
