\name{getTrtCoef}
\alias{getTrtCoef}
\title{
Get the Treatment Coefficients 
}
\description{
Compute the overll coefficients every treatment term including the interaction.
}
\usage{
getTrtCoef(design.df, trtTerm)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{design.df}{
a data frame containing the experimental design. Requires every column be a \code{\link{factor}}.
}
  \item{trtTerm}{
a vector of character containing the labels of the treatment terms in the model generated by \code{\link{terms}}.
}
}
\value{
The numeric vector.
}
\author{
Kevin Chang
}
\examples{
design1 <- local({ 
  Ani = as.factor(LETTERS[c(1,2,3,4,
                            5,6,7,8)])
  Trt = as.factor(letters[c(1,1,1,1,
                            2,2,2,2)])
  data.frame(Ani, Trt)
})

trt.str = "Trt"
  
fT = terms(as.formula(paste("~", trt.str, sep = "")), keep.order = TRUE)  #fixed terms

trtTerm = attr(fT,"term.labels")
effectsMatrix = attr(fT,"factor") 
		
trt.Coef = getTrtCoef(design1, trtTerm)

}
