% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wght_functions.R
\name{wght_calc}
\alias{wght_calc}
\title{Compute IPW weight}
\usage{
wght_calc(parameters, integrand, allocation, integrate_allocation = TRUE, ...)
}
\arguments{
\item{parameters}{vector of parameter values}

\item{integrand}{function to pass to the argument 'f' of \code{\link{integrate}}.}

\item{allocation}{the allocation ratio for which to compute the weight}

\item{integrate_allocation}{Indicator of whether the integrand function uses 
the allocation parameter. Defaults to TRUE.}

\item{...}{other arguments passed to integrand.}
}
\value{
scalar result of the integral
}
\description{
Calculates the IPW for a single group. Used by \code{\link{wght_matrix}} to
create a matrix of weights for each group and allocation scheme.
}
\details{
If \code{allocation} is an argument in the integrand function and
\code{integrate_allocation == TRUE}, then the weight is calcuated as:

\deqn{\frac{1}{Pr(A|X)}}{1 / integrate(integrand)}

Otherwise, the weight is computed by:
\deqn{\frac{\prod_{j=1}^n \alpha^A_j (1 - \alpha)^(1-
A_j)}{Pr(A|X)}}{prod(allocation^A(1 - allocation)^A) / integrate(integrand)}
}
