% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_dsciat.R
\name{multi_dsciat}
\alias{multi_dsciat}
\title{Plot SC-IATs scores}
\usage{
multi_dsciat(
  sciat1,
  sciat2,
  graph = c("density", "boxplot", "point"),
  x_values = TRUE,
  gcolors = c("dark", "greens", "blues", "pinks"),
  label_sc1 = "SC-IAT1",
  label_sc2 = "SC-IAT2",
  label_y = "SC-IAT scores",
  dens_mean = TRUE
)
}
\arguments{
\item{sciat1}{Dataframe with class \code{dsciat}. Contains the \emph{D} for
the first SC-IAT.}

\item{sciat2}{Dataframe with class \code{dsciat}. Contains the \emph{D} for
the second SC-IAT.}

\item{graph}{String. Type of graph to display, might be  \code{density} (default), \code{boxplot}, or \code{point}}

\item{x_values}{Logical. Shows the values for x-axis (default = \code{TRUE}).
Only for the point graph.}

\item{gcolors}{String. Colors palette for plotting the results, might be \code{dark} (default), \code{greens}, \code{blues}, or \code{pinks}.}

\item{label_sc1}{String. Label to display in the graph for the first SC-IAT.
Default is \code{SC-IAT1}.}

\item{label_sc2}{String. Label to display in the graph for the first SC-IAT.
Default is \code{SC-IAT2}.}

\item{label_y}{String. Label to plot on the y-axis.}

\item{dens_mean}{Logical. Whether to include the mean in the density plot.
Default is TRUE.}
}
\value{
A ggplot object
}
\description{
Plot the scores from two different SC-IATs.
}
\examples{
# calculate D for the SCIAT
  data("raw_data") # load data
sciat_data <- clean_sciat(raw_data, sbj_id = "Participant",
                         block_id = "blockcode",
                         latency_id = "latency",
                         accuracy_id = "correct",
                         block_sciat_1 = c("test.sc_dark.Darkbad",
                                           "test.sc_dark.Darkgood"),
                         block_sciat_2 = c("test.sc_milk.Milkbad",
                                           "test.sc_milk.Milkgood"),
                         trial_id  = "trialcode",
                         trial_eliminate = c("reminder",
                                             "reminder1"))

 sciat1 <- sciat_data[[1]] # compute D for the first SC-IAT
 d_sciat1 <- compute_sciat(sciat1,
                    mappingA = "test.sc_dark.Darkbad",
                    mappingB = "test.sc_dark.Darkgood",
                    non_response = "alert") # dataframe with the first D
                                            # SC-IAT

 sciat2 <- sciat_data[[2]] # Compute D for the second SC-IAT
 d_sciat2 <- compute_sciat(sciat2,
                    mappingA = "test.sc_milk.Milkbad",
                    mappingB = "test.sc_milk.Milkgood",
                    non_response = "alert") # dataframe with the first
                                            # D SC-IAT
 multi_dsciat(d_sciat1, d_sciat2) # plot the D of two SC-IATs with default
                                    # settings
}
