% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HLA_truncate.R
\name{HLA_truncate}
\alias{HLA_truncate}
\title{HLA_truncate}
\usage{
HLA_truncate(data, fields = 2, keep_suffix = TRUE, keep_G_P_group = FALSE)
}
\arguments{
\item{data}{A string containing an HLA allele or a GL string.}

\item{fields}{An integer specifying the number of fields to retain in the
truncated values. Default is 2.}

\item{keep_suffix}{A logical value indicating whether to retain any
WHO-recognized suffixes. Default is TRUE.}

\item{keep_G_P_group}{A logical value indicating whether to retain any
G or P group designations. Default is FALSE.}
}
\value{
A string with the HLA typing truncated according to
the specified number of fields and optional suffix retention.
}
\description{
This function truncates HLA typing values in molecular nomenclature
(for example from 4 fields to 2 fields). The truncation is based on the number
of fields specified and optionally retains any WHO-recognized suffixes
(L, S, C, A, Q, or N) or G and P group designations (G or P). This function
will work on individual alleles (e.g. "HLA-A*02:01:01:01") or on all alleles
in a GL string (e.g. "HLA-A*02:01:01:01+HLA-A*68:01:01^HLA-DRB1*01:01:01+HLA-DRB1*03:01:01").
}
\examples{

# The Haplotype_frequencies dataset contains a table with HLA typing spread across multiple columns:
print(Haplotype_frequencies)

# The `HLA_truncate` function can be used to truncate the typing results to 2 fields:
library(dplyr)
Haplotype_frequencies \%>\% mutate(
  across(
    "HLA-A":"HLA-DPB1",
    ~ HLA_truncate(
      .,
      fields = 2,
      keep_suffix = TRUE,
      keep_G_P_group = FALSE
    )
  )
)

}
