% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sat_vapor_pressure.R
\encoding{UTF-8}
\name{sp_gravity}
\alias{sp_gravity}
\title{Specific Volume}
\usage{
sp_gravity(
  rho_w,
  rho_s,
  units = c("SI", "Eng"),
  Eng_units = c("slug/ft^3", "lbm/ft^3")
)
}
\arguments{
\item{rho_w}{numeric vector that contains the density of water}

\item{rho_s}{numeric vector that contains the density of the substance}

\item{units}{character vector that contains the system of units [options are
\code{SI} for International System of Units or \code{Eng} for English units
(United States Customary System in the United States and Imperial Units in
the United Kingdom)]}

\item{Eng_units}{character vector that contains the unit for the density of
water [options are slug/ft^3 or lbm/ft^3]}
}
\value{
the specific volume as a numeric vector
}
\description{
This function solves for the specific volume of a substance using only the
substance's density and the density of water.
}
\details{
The equation is expressed as

\deqn{SG = \frac{\\rho_s}{\\gamma_w} = \frac{\\rho_s}{\\rho_w}}

\describe{
  \item{\emph{SG}}{specific volume (dimensionless)}
  \item{\emph{\\gamma_w}}{unit weight or specific weight of water (N/m^3 or lbf/ft^3)}
  \item{\emph{\\rho_s}}{substance density (mass divided by volume) [kg/m^3, slug/ft^3", or lbm/ft^3]}
  \item{\emph{\\rho_w}}{water density (mass divided by volume) [kg/m^3, slug/ft^3", or lbm/ft^3]}
}
}
\examples{
# Examples

install.load::load_package("iemisc", "units")

# The density of sand is 1500 kg/m^3 -- Reference 1

rho_sand <- set_units(1500, "kg/m^3")


# convert this density to slug/ft^3
rho_sand_slug <- rho_sand

# create a numeric vector with the units of slug/ft^3
units(rho_sand_slug) <- make_units(slug/ft^3)


# convert this density to lbm/ft^3
rho_sand_lbm <- rho_sand

# create a numeric vector with the units of lb/ft^3
units(rho_sand_lbm) <- make_units(lb/ft^3)



rho1 <- density_water(Temp = 68, units = "Eng", Eng_units = "slug/ft^3")

sp_gravity(rho_w = rho1, rho_s = rho_sand_slug, units = "Eng", Eng_units = "slug/ft^3")


rho2 <- density_water(Temp = 68, units = "Eng", Eng_units = "lbm/ft^3")

sp_gravity(rho_w = rho2, rho_s = rho_sand_lbm, units = "Eng", Eng_units = "lbm/ft^3")


rho3 <- density_water(Temp = 20, units = "SI")

sp_gravity(rho_w = rho3, rho_s = rho_sand, units = "SI")




}
\references{
\enumerate{
   \item Material Properties, 27 March 2022, "Sand – Density – Heat Capacity – Thermal Conductivity", \url{https://material-properties.org/sand-density-heat-capacity-thermal-conductivity/}
   \item WikiEngineer, 27 March 2022, "Water Properties & Definitions", \url{https://web.archive.org/web/20210412034245/http://www.wikiengineer.com/Water-Resources/PropertiesAndDefinitions}. Retrieved thanks to the Internet Archive: Wayback Machine
}
}
\author{
Irucka Embry
}
