% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Manningcirc.R
\encoding{UTF-8}
\name{Manningcirc}
\alias{Manningcirc}
\title{Circular Cross-section Using the Gauckler-Manning-Strickler Equation 1}
\usage{
Manningcirc(
  Q = NULL,
  n = NULL,
  Sf = NULL,
  y = NULL,
  d = NULL,
  Temp = NULL,
  units = c("SI", "Eng")
)
}
\arguments{
\item{Q}{numeric vector that contains the discharge value (m^3/s or ft^3/s),
if known.}

\item{n}{numeric vector that contains the Manning's roughness coefficient n,
if known.}

\item{Sf}{numeric vector that contains the bed slope (m/m or ft/ft),
if known.}

\item{y}{numeric vector that contains the flow depth (m or ft), if known.}

\item{d}{numeric vector that contains the diameters value (m or ft),
if known.}

\item{Temp}{numeric vector that contains the temperature (degrees C or degrees
Fahrenheit), if known.}

\item{units}{character vector that contains the system of units [options are
\code{SI} for International System of Units or \code{Eng} for English units
(United States Customary System in the United States and Imperial Units in
the United Kingdom)]}
}
\value{
the missing parameters (Q, n, or Sf) & theta, area (A), wetted
  perimeters (P), velocity (V), top width (B), hydraulic depth (D), hydraulic radius (R), E (Specific Energy), Vel_Head (Velocity Head), Z (Section Factor), Reynolds number (Re), and Froude number (Fr) as a \code{\link[base]{list}}. for the
  Manningcirc function.
}
\description{
Manningcirc and Manningcircy solve for a missing variable for a circular
cross-section. The \code{\link[stats]{uniroot}} function is used to obtain the
missing parameters.

The Manningcirc function solves for one missing variable in the Gauckler-
Manning equation for a circular cross-section and uniform flow. The
possible inputs are Q, n, Sf, y, and d. If y or d are not initially known,
then Manningcircy can solve for y or d to use as input in the Manningcirc
function.
}
\details{
Circular cross-section using the Gauckler-Manning-Strickler equation


Gauckler-Manning-Strickler equation is expressed as

\deqn{V = \frac{K_n}{n}R^\frac{2}{3}\sqrt{S}}

\describe{
  \item{\emph{V}}{the velocity (m/s or ft/s)}
  \item{\emph{n}}{Manning's roughness coefficient (dimensionless)}
  \item{\emph{R}}{the hydraulic radius (m or ft)}
  \item{\emph{S}}{the slope of the channel bed (m/m or ft/ft)}
  \item{\emph{K_n}}{the conversion constant -- 1.0 for SI and
       3.2808399 ^ (1 / 3) for English units -- m^(1/3)/s or ft^(1/3)/s}
}




This equation is also expressed as

\deqn{Q = \frac{K_n}{n}\frac{A^\frac{5}{3}}{P^\frac{2}{3}}\sqrt{S}}

\describe{
  \item{\emph{Q}}{the discharge [m^3/s or ft^3/s (cfs)] is VA}
  \item{\emph{n}}{Manning's roughness coefficient (dimensionless)}
  \item{\emph{P}}{the wetted perimeters of the channel (m or ft)}
  \item{\emph{A}}{the cross-sectional area (m^2 or ft^2)}
  \item{\emph{S}}{the slope of the channel bed (m/m or ft/ft)}
  \item{\emph{K_n}}{the conversion constant -- 1.0 for SI and
       3.2808399 ^ (1 / 3) for English units -- m^(1/3)/s or ft^(1/3)/s}
}




Other important equations regarding the circular cross-section follow:

\deqn{R = \frac{A}{P}}

\describe{
  \item{\emph{R}}{the hydraulic radius (m or ft)}
  \item{\emph{A}}{the cross-sectional area (m^2 or ft^2)}
  \item{\emph{P}}{the wetted perimeters of the channel (m or ft)}
}




\deqn{A = \left(\\theta - \sin \\theta\right) \frac{d^2}{8}}

\describe{
  \item{\emph{A}}{the cross-sectional area (m^2 or ft^2)}
  \item{\emph{d}}{the diameters of the cross-section (m or ft)}
  \item{\emph{\\theta}}{see the equation defining this parameters}
}


\deqn{\\theta = 2 \arcsin\left[1 - 2\left(\frac{y}{d}\right)\right]}

\describe{
  \item{\emph{\\theta}}{see the equation defining this parameters}
  \item{\emph{y}}{the flow depth (normal depth in this function) [m or ft]}
  \item{\emph{d}}{the diameters of the cross-section (m or ft)}
}




\deqn{d = 1.56 \left[\frac{nQ}{K_n\sqrt{S}}\right]^\frac{3}{8}}

\describe{
  \item{\emph{d}}{the initial diameters of the cross-section [m or ft]}
  \item{\emph{Q}}{the discharge [m^3/s or ft^3/s (cfs)] is VA}
  \item{\emph{n}}{Manning's roughness coefficient (dimensionless)}
  \item{\emph{S}}{the slope of the channel bed (m/m or ft/ft)}
  \item{\emph{K_n}}{the conversion constant -- 1.0 for SI and
       3.2808399 ^ (1 / 3) for English units -- m^(1/3)/s or ft^(1/3)/s}
}

Note: This will only provide the initial conduit diameters, check the design
      considerations to determine your next steps.




\deqn{P = \frac{\\theta d}{2}}

\describe{
  \item{\emph{P}}{the wetted perimeters of the channel (m or ft)}
  \item{\emph{\\theta}}{see the equation defining this parameters}
  \item{\emph{d}}{the diameters of the cross-section (m or ft)}
}




\deqn{B = d \sin\left(\frac{\\theta}{2}\right)}

\describe{
  \item{\emph{B}}{the top width of the channel (m or ft)}
  \item{\emph{\\theta}}{see the equation defining this parameters}
  \item{\emph{d}}{the diameters of the cross-section (m or ft)}
}



\deqn{D = \frac{A}{B}}

\describe{
  \item{\emph{D}}{the hydraulic depth (m or ft)}
  \item{\emph{A}}{the cross-sectional area (m^2 or ft^2)}
  \item{\emph{B}}{the top width of the channel (m or ft)}
}



\deqn{Z = \frac{\sqrt{2}}{2}my^2.5}

\describe{
  \item{\emph{Z}}{the Section factor (m or ft)}
  \item{\emph{y}}{the flow depth (normal depth in this function) [m or ft]}
  \item{\emph{m}}{the horizontal side slope}
}



\deqn{E = y + \frac{Q^2}{2gA^2}}

\describe{
  \item{\emph{E}}{the Specific Energy (m or ft)}
  \item{\emph{Q}}{the discharge [m^3/s or ft^3/s (cfs)] is VA}
  \item{\emph{g}}{gravitational acceleration (m/s^2 or ft/sec^2)}
  \item{\emph{A}}{the cross-sectional area (m^2 or ft^2)}
  \item{\emph{y}}{the flow depth (normal depth in this function) [m or ft]}
}




\deqn{VH = \frac{V^2}{2g}}

\describe{
  \item{\emph{VH}}{the Velocity Head (m or ft)}
  \item{\emph{V}}{the velocity (m/s or ft/s)}
  \item{\emph{g}}{gravitational acceleration (m/s^2 or ft/sec^2)}
}



A rough turbulent zone check is performed on the water flowing in the
channel using the Reynolds number (Re). The Re equation follows:

\deqn{Re = \frac{\\rho RV}{\\mu}}

\describe{
  \item{\emph{Re}}{Reynolds number (dimensionless)}
  \item{\emph{\\rho}}{density (kg/m^3 or slug/ft^3)}
  \item{\emph{R}}{the hydraulic radius (m or ft)}
  \item{\emph{V}}{the velocity (m/s or ft/s)}
  \item{\emph{\\mu}}{dynamic viscosity (* 10^-3 kg/m*s or * 10^-5 lb*s/ft^2)}
}



A critical flow check is performed on the water flowing in the channel
using the Froude number (Fr). The Fr equation follows:

\deqn{Fr = \frac{V}{\left(\sqrt{g * D}\right)}}

\describe{
  \item{\emph{Fr}}{the Froude number (dimensionless)}
  \item{\emph{V}}{the velocity (m/s or ft/s)}
  \item{\emph{g}}{gravitational acceleration (m/s^2 or ft/sec^2)}
  \item{\emph{D}}{the hydraulic depth (m or ft)}
}
}
\note{
Assumptions: uniform flow, prismatic channel, and surface water temperature
of 20 degrees Celsius (68 degrees Fahrenheit) at atmospheric pressure

Note: Units must be consistent

Please refer to the iemisc: Manning... Examples using iemiscdata
[https://www.ecoccs.com/R_Examples/Manning_iemiscdata_Examples.pdf] and iemisc:
Open Channel Flow Examples involving Geometric Shapes with the
Gauckler-Manning-Strickler Equation
[https://www.ecoccs.com/R_Examples/Open-Channel-Flow_Examples_Geometric_Shapes.pdf]
for the cross-section examples using iemiscdata
}
\references{
\enumerate{
   \item Terry W. Sturm, \emph{Open Channel Hydraulics}, 2nd Edition, New York City, New York: The McGraw-Hill Companies, Inc., 2010, page 2, 8, 36, 102, 120, 123-125, 153-154.
   \item Dan Moore, P.E., NRCS Water Quality and Quantity Technology Development Team, Portland Oregon, "Using Mannings Equation with Natural Streams", August 2011, \url{https://web.archive.org/web/20210416091858/https://www.wcc.nrcs.usda.gov/ftpref/wntsc/H&H/xsec/manningsNaturally.pdf}. Retrieved thanks to the Internet Archive: Wayback Machine
   \item Gilberto E. Urroz, Utah State University Civil and Environmental Engineering - OCW, CEE6510 - Numerical Methods in Civil Engineering, Spring 2006 (2006). Course 3. "Solving selected equations and systems of equations in hydraulics using Matlab", August/September 2004, \url{https://digitalcommons.usu.edu/ocw_cee/3/}.
   \item Tyler G. Hicks, P.E., \emph{Civil Engineering Formulas: Pocket Guide}, 2nd Edition, New York City, New York: The McGraw-Hill Companies, Inc., 2002, page 423, 425.
   \item Wikimedia Foundation, Inc. Wikipedia, 26 November 2015, "Manning formula", \url{https://en.wikipedia.org/wiki/Manning_formula}.
   \item John C. Crittenden, R. Rhodes Trussell, David W. Hand, Kerry J. Howe, George Tchobanoglous, \emph{MWH's Water Treatment: Principles and Design}, Third Edition, Hoboken, New Jersey: John Wiley & Sons, Inc., 2012, page 1861-1862.
   \item Andrew Chadwick, John Morfett and Martin Borthwick, \emph{Hydraulics in Civil and Environmental Engineering}, Fourth Edition, New York City, New York: Spon Press, Inc., 2004, page 133.
   \item Robert L. Mott and Joseph A. Untener, \emph{Applied Fluid Mechanics}, Seventh Edition, New York City, New York: Pearson, 2015, page 376, 377-378, 392.
   \item Ven Te Chow, Ph.D., \emph{Open-Channel Hydraulics}, McGraw-Hill Classic Textbook Reissue, New York City, New York: McGraw-Hill Book Company, 1988, pages 21, 40-41.
   \item Gary P. Merkley, "BIE6300 - Irrigation & Conveyance Control Systems, Spring 2004", 2004, Biological and Irrigation Engineering - OCW. Course 2, \url{https://digitalcommons.usu.edu/ocw_bie/2/}.
   \item The NIST Reference on Constants, Units, and Uncertainty, Fundamental Constants Data Center of the NIST Physical Measurement Laboratory, "standard acceleration of gravity g_n", \url{https://physics.nist.gov/cgi-bin/cuu/Value?gn}.
   \item Wikimedia Foundation, Inc. Wikipedia, 15 May 2019, "Conversion of units", \url{https://en.wikipedia.org/wiki/Conversion_of_units}.
}
}
\seealso{
\code{\link{Manningtrap}} for a trapezoidal cross-section, \code{\link{Manningrect}} for a
  rectangular cross-section, \code{\link{Manningtri}} for a triangular cross-section,
  and \code{\link{Manningpara}} for a parabolic cross-section.

\code{\link{Manningcircy}}
}
\author{
Irucka Embry
}
