% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\encoding{UTF-8}
\name{numel}
\alias{numel}
\title{Number of elements (GNU Octave/MATLAB compatible)}
\source{
\enumerate{
   \item r - Add a Column to a Dataframe From a List of Values - Stack Overflow answered by Matthew Plourde on Jun 21 2012. See \url{https://stackoverflow.com/questions/11130037/add-a-column-to-a-dataframe-from-a-list-of-values/11130178}.
   \item r - Why does is.vector() return TRUE for list? - Stack Overflow answered by Andrie on May 17 2011. See \url{https://stackoverflow.com/questions/6032772/why-does-is-vector-return-true-for-list/6032909}.
}
}
\usage{
numel(x, ...)
}
\arguments{
\item{x}{An R object (array, matrix, vector)}

\item{...}{R objects (indices idx1, idx2, ...)}
}
\value{
"Return the number of elements in the R object x. Optionally, if
  indices idx1, idx2, ... are supplied, return the number of elements that
  would result from the indexing a(idx1, idx2, ...)." Source: Eaton page 41.
}
\description{
Obtain the number of elements of R objects [arrays, matrices, and vectors
(including lists)] in a manner compatible with GNU Octave/MATLAB. Some
documentation from \code{\link[base]{length}}.
}
\examples{

library(iemisc)

import::from(matlab, ones)

xx <- list(1:26, 1:10)

numel(xx)





}
\references{
\enumerate{
   \item Samit Basu (2002-2006). FreeMat v4.0, \url{https://freemat.sourceforge.net/help/inspection_numel.html}.
   \item John W. Eaton, David Bateman, Søren Hauberg, and Rik Wehbring (November 2022). \emph{GNU Octave: A high-level interactive language for numerical computations: Edition 7 for Octave version 7.3.0}. \url{https://docs.octave.org/octave.pdf}. Page 46-47.
}
}
\seealso{
\code{\link[matlab]{numel}}, \code{\link[pracma]{numel}}, \code{\link{size}}, \code{\link[base]{length}}, \code{\link{length_octave}}
}
\author{
Irucka Embry, Samit Basu (FreeMat)
}
