% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f.R
\encoding{UTF-8}
\name{f1}
\alias{f1}
\title{Laminar Flow Equation}
\usage{
f1(Re)
}
\arguments{
\item{Re}{numeric vector that contains the Reynolds number (dimensionless)}
}
\value{
the dimensionless Darcy friction factor (f) as a numeric \code{\link[base]{vector}}
}
\description{
The Darcy friction factor (f) is used in the "Darcy equation (also known as
the Weisbach equation or Darcy-Weisbach equation)" to determine the
"frictional energy loss for fluids" experiencing either laminar or turbulent
flow (which is based on the Reynolds number). {Reference: Lindeburg Manual}
}
\details{
Calculating the Darcy friction factor (f) for pipes


Please consult the references for the equations:

f1 - laminar flow equation (References: Lindeburg Manual and Zeghadnia)
f2 - Moody equation (References: Genić and Zeghadnia)
f3 - Romeo, et. al. equation (References: Genić and Zeghadnia)
f4 - Žarko Ćojbašića and Dejan Brkić equation (Reference: Zeghadnia)
f5 - Colebrook-White equation (References: Genić and Praks)
f6 - Swamee-Jaine equation (References: Genić and Zeghadnia)
f7 - Zigrang-Sylvester equation (References: Genić and Zeghadnia)
f8 - Vatankhah equation (Reference: Zeghadnia)
}
\examples{

library("iemisc")

# Examples

f1(200)

f1(1999)




}
\references{
\enumerate{
   \item Steven C. Chapra, \emph{Applied Numerical Methods with MATLAB for Engineers and Scientists}, Second Edition, Boston, Massachusetts: McGraw-Hill, 2008, pages 157-161.
   \item Didier Clamond, "Efficient resolution of the Colebrook equation", \emph{Ind. Eng. Chem. Res.}, 2009, 48 (7), pages 3665-3671, \url{https://arxiv.org/abs/0810.5564} and \url{https://pubs.acs.org/doi/pdf/10.1021/ie801626g}
   \item Srbislav Genić, Ivan Arandjelović, Petar Kolendić, Marko Jarić, Nikola Budimir, and Vojislav Genić, "A Review of Explicit Approximations of Colebrook's Equation", \emph{FME (Faculty of Mechanical Engineering, Belgrade) Transactions}, 2011, 39, pages 67-71, \url{https://www.mas.bg.ac.rs/_media/istrazivanje/fme/vol39/2/04_mjaric.pdf}
   \item Michael R. Lindeburg, PE, \emph{Civil Engineering Reference Manual for the PE Exam}, Twelfth Edition, Belmont, California: Professional Publications, Inc., 2011, pages 17-5 - 17-7.
   \item Michael R. Lindeburg, PE, \emph{Practice Problems for the Civil Engineering PE Exam: A Companion to the "Civil Engineering Reference Manual"}, Twelfth Edition, Belmont, California: Professional Publications, Inc., 2011, pages 17-1 and 17-8 - 17-9.
   \item Pavel Praks and Dejan Brkić, "Advanced Iterative Procedures for Solving the Implicit Colebrook Equation for Fluid Flow Friction", \emph{Advances in Civil Engineering}, Volume 2018, Article ID 5451034, 18 pages, \url{https://www.hindawi.com/journals/ace/2018/5451034/}
   \item Lotfi Zeghadnia, Jean Loup Robert, and Bachir Achour, "Explicit solutions for turbulent flow friction factor: A review, assessment and approaches classification", \emph{Ain Shams Engineering Journal}, March 2019, Volume 10, Issue 1, pages 243-252, \url{https://www.sciencedirect.com/science/article/pii/S2090447919300176}
}
}
\seealso{
\code{\link{Re1}}, \code{\link{Re2}}, \code{\link{Re3}}, and \code{\link{Re4}} for the Reynolds number and \code{\link{colebrook}}
for an accurate representation of the Colebrook-White equation

\code{\link{f2}}, \code{\link{f3}}, \code{\link{f4}}, \code{\link{f5}}, \code{\link{f6}}, \code{\link{f7}}, \code{\link{f8}}
}
\author{
Irucka Embry
}
