% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimpIntPaid.R
\encoding{UTF-8}
\name{SimpIntCharg}
\alias{SimpIntCharg}
\title{Simple Interest Charged (Engineering Economics)}
\usage{
SimpIntCharg(P, n, i)
}
\arguments{
\item{P}{numeric vector that contains the present value(s)}

\item{n}{numeric vector that contains the period value(s)}

\item{i}{numeric vector that contains the interest rate(s) as whole number
or decimal}
}
\value{
SimpIntCharg numeric vector that contains the simple interest amount
   paid at the end of n periods rounded to 2 decimal places
}
\description{
Computes the total interest paid at the end of n periods using simple
interest
}
\details{
Simple Interest Charged is expressed as

\deqn{I = Pni}

\describe{
\item{\emph{P}}{the "principal amount (lent or borrowed)"}
\item{\emph{I}}{the "simple interest"}
\item{\emph{i}}{the "interest rate per interest period"}
\item{\emph{n}}{the "number of interest periods"}
}
}
\examples{

library("iemisc")

# Example for equation 4-1 from the Sullivan Reference text (page 116)
# Modified example to provide the simple interest amount paid only

SimpIntCharg(P = 1000, n = 3, i = 10) # the interest rate is 10\%



}
\references{
\enumerate{
\item Chinyere Onwubiko, \emph{An Introduction to Engineering}, Mission, Kansas: Schroff Development Corporation, 1997, page 205-206.
\item William G. Sullivan, Elin M. Wicks, and C. Patrick Koelling, \emph{Engineering Economy}, Fourteenth Edition, Upper Saddle River, New Jersey: Pearson/Prentice Hall, 2009, page 116.
}
}
\author{
Irucka Embry
}
