% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgivenFcont.R
\encoding{UTF-8}
\name{AgivenPcont}
\alias{AgivenPcont}
\title{Annual value given Present value [continuous] (Engineering Economics)}
\usage{
AgivenPcont(P, n, r)
}
\arguments{
\item{P}{numeric vector that contains the present value(s)}

\item{n}{numeric vector that contains the period value(s)}

\item{r}{numeric vector that contains the continuously compounded nominal
annual interest rate(s) as a percent}
}
\value{
AgivenPcont numeric vector that contains the annual value(s)
   rounded to 2 decimal places
}
\description{
Compute A given P with interest compounded continuously
}
\details{
A is expressed as

\deqn{A = P\left[\frac{e^{rn}\left(e^{r} - 1\right)}{e^{rn} - 1}\right]}

\describe{
\item{\emph{A}}{the "annual equivalent amount (occurs at the end of
    each year)"}
\item{\emph{P}}{the "present equivalent"}
\item{\emph{r}}{the "nominal annual interest rate, compounded
    continuously"}
\item{\emph{n}}{the "number of periods (years)"}
}
}
\examples{
library(iemisc)
# Example for equation 4-34 from the Reference text (page 170)
AgivenPcont(1000, 10, 20) # 20\% interest




}
\references{
William G. Sullivan, Elin M. Wicks, and C. Patrick Koelling, \emph{Engineering Economy}, Fourteenth Edition, Upper Saddle River, New Jersey: Pearson/Prentice Hall, 2009, page 169-170.
}
