% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relerror.R
\encoding{UTF-8}
\name{approxerror}
\alias{approxerror}
\title{Approximate error}
\usage{
approxerror(pres, prev)
}
\arguments{
\item{pres}{numeric vector that contains the "present approximation"
value(s)}

\item{prev}{numeric vector that contains the "previous approximation"
value(s)}
}
\value{
approximate error, as a percent (\%), as a numeric \code{\link{vector}}.
}
\description{
This function computes the "approximate estimate of the error" ("percent relative error").
}
\details{
Approximate error is expressed as

\deqn{\varepsilon_{a} = \frac{{present \: approximation} - {previous \: approximation}}{present \: approximation} \cdot 100}

\describe{
\item{\emph{\eqn{\varepsilon_a}}}{the "approximate estimate of the error"}
\item{\emph{present approximation}}{the "present approximation"}
\item{\emph{previous approximation}}{the "previous approximation"}
}
}
\examples{
library(iemisc)
# Example 4.1 from the Reference text (page 84)
approxerror(1.5, 1) # answer as a percent (\\\%)



}
\references{
Steven C. Chapra, \emph{Applied Numerical Methods with MATLAB for Engineers and Scientists}, Second Edition, Boston, Massachusetts: McGraw-Hill, 2008, page 82-84.
}
\seealso{
\code{\link{sgm}} for geometric mean, \code{\link{shm}} for harmonic mean, \code{\link{cv}} for
 coefficient of variation (CV), \code{\link{rms}} for root-mean-square (RMS), \code{\link{relerror}}
 for relative error, and \code{\link{ranges}} for sample range.
}

