% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_support.R
\name{Datatrans}
\alias{Datatrans}
\title{Data transformation.}
\usage{
Datatrans(pkg, des, y, n.alts, n.sets, n.resp, n.par, no.choice, bin)
}
\arguments{
\item{pkg}{Indicates the required package for estimation (\code{1 = 
  \link[bayesm]{rhierMnlRwMixture}}, \code{2 = 
  \link[ChoiceModelR]{choicemodelr}}, \code{3 = \link[RSGHB]{doHB}} and
\code{4 = \link[bayesm]{rbprobitGibbs}}).}

\item{des}{A design matrix in which each row is a profile. Can be generated
with \code{\link{Modfed}}}

\item{y}{A numeric matrix. Each columnvector is the sequence of choices of a
unique respondent. There can be \code{n.sets} rows with discrete values
indicating the chosen alternative of that set, or there can be \code{n.sets
  * n.alts} rows with binary values indicating for each alternative whether it
was chosen or not. In the latter case the \code{bin} argument should be
\code{TRUE}.}

\item{n.alts}{Numeric value indicating the number of alternatives per choice
set.}

\item{n.sets}{Numeric value indicating the number of choice sets.}

\item{n.resp}{Numeric value indicating the number of respondents.}

\item{n.par}{Numeric value indicating the number of model parameters that
needs to be estimated.}

\item{no.choice}{Logical value indicating whether a no choice response could
be observed. This would be a \code{0} for each alternative.}

\item{bin}{Logical value indicating whether the reponse matrix contains
binary data (\code{TRUE}) or discrete data (\code{FALSE}). See \code{y}.}
}
\value{
The data ready to be used by the specified package.
}
\description{
Transforms the data into the neccesary format in order to use estimation
functions from different packages.
}
\examples{
# 3 Attributes, 2 are dummy coded and 1 continuous.
cs <- Profiles(lvls = c(2, 3, 2), coding = c("D", "C", "D"), c.lvls = list(c(2,4,6)))
p <- c(0.8, 0.2, -0.3) # parameter vector
# Generate design
des <- Modfed(cand.set = cs, n.sets = 8, n.alts = 2, alt.cte = c(0,0), par.draws = p)$des
# Generate responses
y <- RespondMNL(par = p, des = des, n.alts = 2)
y <- matrix(y, 16)
#  data 
Datatrans(pkg = 4, des = des, y = y, n.alts = 2, n.sets = 8, n.resp = 1,
          n.par = 3, no.choice = FALSE, bin = TRUE)
}
