% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heuristics.R
\name{roc_curve.glmnetcv_classifier}
\alias{roc_curve.glmnetcv_classifier}
\title{Construct an ROC curve using a trained \code{\link{glmnetcv_classifier}}
on the given data}
\usage{
\method{roc_curve}{glmnetcv_classifier}(obj, X, y, fit_index = NULL, ...)
}
\arguments{
\item{obj}{The learner or grid to use for prediction.}

\item{X}{The features of the data.}

\item{y}{The labels of the data.}

\item{fit_index}{The index of the fit in the path to use for prediction,
defaulting to the best fit if not supplied.}

\item{...}{Refer to the Julia documentation for available parameters.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.2.1/Heuristics/reference/#IAI.ROCCurve-Tuple\%7BGLMNetCVClassifier\%2C\%20Union\%7BDataFrames.AbstractDataFrame\%2C\%20AbstractMatrix\%7B\%3C\%3AReal\%7D\%7D\%2C\%20AbstractVector\%7D}{\code{IAI.ROCCurve}}
}
\section{IAI Compatibility}{

Requires IAI version 3.0 or higher.
}

\examples{
\dontrun{iai::roc_curve(lnr, X, y)}

}
