% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url.R
\name{url_parse}
\alias{url_parse}
\title{Parse a URL into its component pieces}
\usage{
url_parse(url, base_url = NULL)
}
\arguments{
\item{url}{A string containing the URL to parse.}

\item{base_url}{Use this as a parent, if \code{url} is a relative URL.}
}
\value{
An S3 object of class \code{httr2_url} with the following components:
\code{scheme}, \code{hostname}, \code{username}, \code{password}, \code{port}, \code{path}, \code{query}, and
\code{fragment}.
}
\description{
\code{url_parse()} parses a URL into its component parts, powered by
\code{\link[curl:curl_parse_url]{curl::curl_parse_url()}}. The parsing algorithm follows the specifications
detailed in \href{https://datatracker.ietf.org/doc/html/rfc3986}{RFC 3986}.
}
\examples{
url_parse("http://google.com/")
url_parse("http://google.com:80/")
url_parse("http://google.com:80/?a=1&b=2")
url_parse("http://username@google.com:80/path;test?a=1&b=2#40")

# You can parse a relative URL if you also provide a base url
url_parse("foo", "http://google.com/bar/")
url_parse("..", "http://google.com/bar/")
}
\seealso{
Other URL manipulation: 
\code{\link{url_build}()},
\code{\link{url_modify}()}
}
\concept{URL manipulation}
