% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ckd_epi_eq.R
\name{ckd_epi_eq}
\alias{ckd_epi_eq}
\title{CKD-EPI equation for GFR.}
\usage{
ckd_epi_eq(scr, gender, reth, age_years, ckd_epi_race_coeff = FALSE)
}
\arguments{
\item{scr}{Vector of serum creatinine values in mg/dL.}

\item{gender}{Vector of genders (either 'Male' or 'Female').}

\item{reth}{Vector of races/ethnicities. Not used unless ckd_epi_race_coeff is TRUE.}

\item{age_years}{Vector of ages in years.}

\item{ckd_epi_race_coeff}{Whether to use the "race coefficient" in the CKD-EPI equation. Default is FALSE.}
}
\value{
Vector of GFR values in mL/min/1.73m^2.
}
\description{
Predict GFR from serum creatinine, gender, and age.
}
\details{
From Levey AS, Stevens LA, Schmid CH, Zhang YL, Castro AF, Feldman HI, et al. A new
equation to estimate glomerular filtration rate. Ann Intern Med 2009;
150(9):604-612. doi:10.7326/0003-4819-150-9-200905050-00006
}
\references{
\insertRef{ring2017identifying}{httk}
}
\author{
Caroline Ring
}
\keyword{httk-pop}
