% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_threeletter_holland.R
\name{con_threeletter_holland}
\alias{con_threeletter_holland}
\title{Congruence Index according to Wolfe & Betz (1981)}
\usage{
con_threeletter_holland(a, b)
}
\arguments{
\item{a}{a character vector with person Holland codes.}

\item{b}{a character vector with environment Holland codes.}
}
\value{
a numeric with value for congruence.
}
\description{
The function computes the three-letter congruence index according to Wolfe & Betz (1981).
}
\details{
The function finds the congruence according to Wolfe & Betz (1981) between the three-letter Holland codes given in argument a, which is the person code, and argument b, which is the environment code. The Index as defined by Wolfe & Betz (1981) targets (only) three letters from the Holland code. The degree of congruence is output, according to its definition by Wolfe & Betz (1981), as a reciprocal value of a distance. This means, for example, that a value of '2' is the result for a perfect fit of two three-letter codes !
}
\examples{
con_threeletter_holland(a="RIA",b="SEC") # max. difference 
con_threeletter_holland(a="RIA",b="RIA") # max. similarity
}
\references{
Holland, J.L. 1963. A theory of vocational choice. I. Vocational images and choice. \emph{Vocational Guidance Quarterly, 11}(4), 232–239.

Wolfe, L. K. & Betz, N. E. (1981). Traditionality of choice and sex-role identification as moderators of the congruence of occupational choice in college women. \emph{Journal of Vocational Behavior, 18}(1), 43–55. https://doi.org/10.1016/0001-8791(81)90028-2
}
\keyword{congruence}
