% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivative_functions.R
\name{directional_deriv}
\alias{directional_deriv}
\title{Derivative inner product}
\usage{
directional_deriv(em, x, v, sd = NULL, ...)
}
\arguments{
\item{em}{The emulator in question}

\item{x}{The point in input space to evaluate at}

\item{v}{The direction to assess}

\item{sd}{How many standard deviations to consider.}

\item{...}{Additional arguments to pass through (eg local.var to the emulator functions)}
}
\value{
Either a single numeric or a pair of numerics (see description)
}
\description{
Find the (uncertainty modified) inner product between the derivative at a point \code{x}
and a proposed direction \code{v}.
}
\details{
Given a point \code{x} and a direction \code{v}, we find the overlap between E[f'(x)] and
\code{v}. The emulated derivative has uncertainty associated with it: the variance is taken
into account using \eqn{v^{T} Var[f'(x)] v}.

If \code{sd == NULL}, then only the (normed) overlap between the derivative and the direction
vector is returned. Otherwise a pair of values are returned: these are the normed overlap plus
or minus \code{sd} times the uncertainty.

This function is concerned with ascertaining whether a direction is oriented in the direction
of the emulator gradient, subject to the uncertainty around the estimate of the derivative.
It allows for a consideration of "emulated gradient descent".
}
\examples{
 directional_deriv(SIREmulators$ems[[1]], SIRSample$validation[1,], c(1,1,1))

}
