% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_dis_plot.R
\name{pair_dis_plot}
\alias{pair_dis_plot}
\title{Pairwise dissimilarity plot}
\usage{
pair_dis_plot(distance, hierarchy, type, level, colour, magnify)
}
\arguments{
\item{distance}{Matrix of pairwise dissimilarities, usually one of the matrices listed in the output object of the pair_dis() function.}

\item{hierarchy}{The first column lists the sample names while the second lists the groups. If provided, group profiles are plotted instead of individual profiles.}

\item{type}{Whether to plot a NMDS or qgraph chart. type="NMDS".}

\item{level}{If '1', samples are not grouped (each sample is a different colour), while if '2', samples are coloured by groups. level=1.}

\item{colour}{he number of vector items (colours, e.g. '#34k235'), must equal the number of samples or groups that are intended to plot.}

\item{magnify}{Only relevant for qgraph. Whether the pairwise dissimilarity values are transformed to 0-1 scale, 0 corresponding to the minimum dissimilarity and 1 to the maximum dissimilarity value. magnify=FALSE.}
}
\value{
An NMDS or network plot.
}
\description{
Visualisation of pairwise dissimilarities
}
\details{
Pairwise dissimilarity plot
}
\examples{
data(bat.diet.otutable)
data(bat.diet.tree)
data(bat.diet.hierarchy)
pairdisres <- pair_dis(bat.diet.otutable,qvalue=0,hierarchy=bat.diet.hierarchy,level="2")
pair_dis_plot(pairdisres$L2_CqN,hierarchy=bat.diet.hierarchy,type="NMDS",level=2)
pair_dis_plot(pairdisres$L2_CqN,hierarchy=bat.diet.hierarchy,type="qgraph",level=2)
}
\references{
Alberdi, A., Gilbert, M.T.P. (2019). A guide to the application of Hill numbers to DNA-based diversity analyses. Molecular Ecology Resources, 19, 804-817.\cr\cr
Chao, A., Chiu, C.H., & Hsieh, T. C. (2012). Proposing a resolution to debates on diversity partitioning. Ecology, 93, 2037-2051.\cr\cr
Jost, L. (2007). Partitioning diversity into independent alpha and beta components. Ecology, 88, 2427-2439.
}
\seealso{
\code{\link{pair_dis}}, \code{\link{beta_dis}}
}
\author{
Antton Alberdi, \email{anttonalberdi@gmail.com}
}
\keyword{diversity}
\keyword{hill}
\keyword{numbers}
\keyword{pairwise}
\keyword{partitioning}
