% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_div.R
\name{index_div}
\alias{index_div}
\title{Diversity index computation}
\usage{
index_div(abund, tree, index)
}
\arguments{
\item{abund}{A vector or a matrix/data.frame indicating the relative abundances of one or multiple samples, respectively. If a matrix/data.frame is provided, columns must refer to samples and rows to OTUs.}

\item{tree}{An ultrametic tree of class 'phylo'. The tip labels must match the names of the vector values (if one sample) or matrix rows (if multiple samples). Use the function match_data() if the OTU names do not match.}

\item{index}{Diversity index to be computed ("richness", "shannon", "simpson", "faith", "allen", "rao"). Default without tree argument: index="richness". Default with tree argument: index="faith".}
}
\description{
Computes common diversity indices related to Hill numbers. If the input is a vector, the function computes the indices of a single sample, while if the input is a matrix (OTU table), the function computes individual diversity indices for each sample (column). An ultrametic OTU tree is required for computing phylogenetic diversity indices (Faith's PD, Allen's H and Rao's Q). If the relative abundances of each sample (vector or each column of the matrix) do not sum to 1, TSS normalisation is applied.
}
\details{
Diversity index computation
}
\examples{
data(bat.diet.otutable)
data(bat.diet.tree)
data(bat.diet.hierarchy)
#One sample
bat.diet.sample <- bat.diet.otutable[,1]
index_div(bat.diet.sample)
index_div(bat.diet.sample,index="shannon")
#Multiple samples
index_div(bat.diet.otutable)
index_div(bat.diet.otutable,tree=bat.diet.tree,index="faith")
#Incidence-based
bat.diet.otutable.incidence <- to.incidence(bat.diet.otutable,bat.diet.hierarchy)
index_div(bat.diet.otutable.incidence)
index_div(bat.diet.otutable.incidence,index="simpson")
index_div(to.incidence(bat.diet.otutable,bat.diet.hierarchy),tree=bat.diet.tree)
}
\references{
Alberdi, A., Gilbert, M.T.P. (2019). A guide to the application of Hill numbers to DNA-based diversity analyses. Molecular Ecology Resources, 19, 804-817.\cr\cr
Jost, L. (2006). Entropy and diversity. Oikos, 113, 363-375.\cr\cr
Rao, C. R. (1982). Diversity and dissimilarity coefficients: A unified approach. Theoretical Population Biology, 21, 24-43.\cr\cr
Shannon, C. E. (1948). A mathematical theory of communication. The Bell System Technical Journal, 27, 379-423.\cr\cr
}
\seealso{
\code{\link{hill_div}}, \code{\link{div_part}}
}
\author{
Antton Alberdi, \email{anttonalberdi@gmail.com}
}
\keyword{ASV}
\keyword{Hill}
\keyword{OTU}
\keyword{diversity}
