% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umap_list.R
\name{umap_list}
\alias{umap_list}
\title{UMAP Projection}
\usage{
umap_list(.data, .kmeans_map_tbl, .k_cluster = 5)
}
\arguments{
\item{.data}{The data from the \code{\link[=kmeans_user_item_tbl]{kmeans_user_item_tbl()}} function.}

\item{.kmeans_map_tbl}{The data from the \code{\link[=kmeans_mapped_tbl]{kmeans_mapped_tbl()}}.}

\item{.k_cluster}{Pick the desired amount of clusters from your analysis of the scree plot.}
}
\value{
A list of tibbles and the umap object
}
\description{
Create a umap object from the \code{\link[uwot:umap]{uwot::umap()}} function.
}
\details{
This takes in the user item table/matix that is produced by \code{\link[=kmeans_user_item_tbl]{kmeans_user_item_tbl()}}
function. This function uses the defaults of \code{\link[uwot:umap]{uwot::umap()}}.
}
\examples{
library(healthyR.data)
library(healthyR)
library(dplyr)
library(broom)

data_tbl <- healthyR_data \%>\%
    filter(ip_op_flag == "I") \%>\%
    filter(payer_grouping != "Medicare B") \%>\%
    filter(payer_grouping != "?") \%>\%
    select(service_line, payer_grouping) \%>\%
    mutate(record = 1) \%>\%
    as_tibble()

uit_tbl <- kmeans_user_item_tbl(
   .data           = data_tbl
   , .row_input    = service_line
   , .col_input    =  payer_grouping
   , .record_input = record
 )

kmm_tbl <- kmeans_mapped_tbl(uit_tbl)

umap_list(.data = uit_tbl, kmm_tbl, 3)

}
\seealso{
\itemize{
\item \url{https://cran.r-project.org/package=uwot} (CRAN)
\item \url{https://github.com/jlmelville/uwot} (GitHub)
\item \url{https://github.com/jlmelville/uwot} (arXiv paper)
}
}
\author{
Steven P. Sanderson II, MPH
}
