% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_tbl_functions.R
\name{ts_census_los_daily_tbl}
\alias{ts_census_los_daily_tbl}
\title{Time Series - Census and LOS by Day}
\usage{
ts_census_los_daily_tbl(
  .data,
  .keep_nulls_only = FALSE,
  .start_date_col,
  .end_date_col,
  .by_time = "day"
)
}
\arguments{
\item{.data}{The data you want to pass to the function}

\item{.keep_nulls_only}{A boolean that will keep only those records that have
a NULL end date, meaning the patient is still admitted. The default is FALSE which
brings back all records.}

\item{.start_date_col}{The column containing the start date for the record}

\item{.end_date_col}{The column containing the end date for the record.}

\item{.by_time}{How you want the data presented, defaults to day and should remain
that way unless you need more granular data.}
}
\value{
A tibble object
}
\description{
Sometimes it is important to know what the census was on any given day, or what
the average length of stay is on given day, including for those patients that
are not yet discharged. This can be easily achieved. This will return one
record for every account so the data will still need to be summarized.

\strong{This function can take a little bit of time to run while the join comparison runs.}
}
\details{
\itemize{
\item Requires a dataset that has at least a start date column and an end date
column
\item Takes a single boolean parameter
}
}
\examples{
library(healthyR)
library(healthyR.data)
library(dplyr)

df <- healthyR_data

df_tbl <- df \%>\%
  filter(ip_op_flag == "I") \%>\%
  select(visit_start_date_time, visit_end_date_time) \%>\%
  timetk::filter_by_time(.date_var = visit_start_date_time, .start_date = "2020")

ts_census_los_daily_tbl(
   .data              = df_tbl
   , .keep_nulls_only = FALSE
   , .start_date_col  = visit_start_date_time
   , .end_date_col    = visit_end_date_time
)

}
\author{
Steven P. Sanderson II, MPH
}
