% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mas.R
\name{mas}
\alias{mas}
\title{Moving average smoothing}
\usage{
mas(x, order)
}
\arguments{
\item{x}{A numeric vector or univariate time series.}

\item{order}{Order of moving average smoother.}
}
\value{
Numerical time series of length \code{length(x)-order+1} containing
the simple moving average smoothed values.
}
\description{
The \code{mas()} function returns a simple moving average smoother of the
provided time series.
}
\details{
The moving average smoother transformation is given by \deqn{(1/k) * (
x[t] + x[t+1] + ... + x[t+k-1] )} where \code{k=order}, \code{t} assume
values in the range \code{1:(n-k+1)}, and \code{n=length(x)}. See also the
\code{\link[forecast]{ma}} of the \code{forecast} package.
}
\examples{
#loading the example database
data(examples_changepoints)

#Using simple example
dataset <- examples_changepoints$simple
head(dataset)

# setting up change point method
ma <- mas(dataset$serie, 5)
}
\references{
R.H. Shumway and D.S. Stoffer, 2010, Time Series Analysis and
Its Applications: With R Examples. 3rd ed. 2011 edition ed. New York,
Springer.
}
\keyword{average}
\keyword{daltoolbox::transform}
\keyword{moving}
\keyword{series}
\keyword{smoother}
\keyword{time}
