% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{gr_summarize}
\alias{gr_summarize}
\title{Summarize hydrograph separation}
\usage{
gr_summarize(df, year_min = NULL, year_max = NULL)
}
\arguments{
\item{df}{\code{data.frame} of hydrograph separation resulting from \code{\link[=gr_separate]{gr_separate()}} function}

\item{year_min}{\code{integer} first year to summarise}

\item{year_max}{\code{integer} last year to summarise}
}
\value{
\code{data.frame} with one row for each water-resources year and multiple columns of statistics explained by \code{\link[=gr_help_vars]{gr_help_vars()}}.
}
\description{
Use this function to get meaningful summary statistics for hydrograph separation. Resulting variables are described by \code{\link[=gr_help_vars]{gr_help_vars()}}. This function is a convenient wrapper around \href{https://dplyr.tidyverse.org}{dplyr}'s \code{df \%>\% group_by \%>\% summarize} idiom.
}
\examples{
library(grwat)

data(spas) # example Spas-Zagorye data is included with grwat package

# separate
sep = gr_separate(spas, params = gr_get_params(reg = 'center'))

# summarize
vars = gr_summarize(sep)

head(vars)

gr_plot_vars(vars, Qygr, tests = TRUE)
}
