% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectnorm.R
\name{drectnorm}
\alias{drectnorm}
\alias{rectNormal}
\alias{prectnorm}
\alias{qrectnorm}
\alias{rrectnorm}
\title{Rectified Normal Distribution}
\usage{
drectnorm(q, mu = 0, sigma = 1, log = FALSE)

prectnorm(q, mu = 0, sigma = 1)

qrectnorm(p, mu = 0, sigma = 1)

rrectnorm(n = 1, mu = 0, sigma = 1)
}
\arguments{
\item{q}{vector of quantiles.}

\item{mu}{vector of location parameters (means).}

\item{sigma}{vector of scale parameters.}

\item{log}{if \code{TRUE}, then probabilities are returned in
logarithms.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. Should be a single number.}
}
\value{
Depending on the function, various things are returned
(usually either vector or scalar):
\itemize{
\item \code{drectnorm} returns the density function value for the
provided parameters.
\item \code{prectnorm} returns the value of the cumulative function
for the provided parameters.
\item \code{qrectnorm} returns quantiles of the distribution. Depending
on what was provided in \code{p}, \code{mu} and \code{sigma}, this
can be either a vector or a matrix, or an array.
\item \code{rrectnorm} returns a vector of random variables
generated from the RectN distribution. Depending on what was
provided in \code{mu} and \code{sigma}, this can be either a vector
or a matrix or an array.
}
}
\description{
Density, cumulative distribution, quantile functions and random number
generation for the Rectified Normal distribution.
}
\details{
If x~N(mu, sigma^2) then y = max(0, x) follows Rectified Normal distribution:
y~RectN(mu, sigma^2), which can be written as:

f_y = 1(x<=0) F_x(mu, sigma) + 1(x>0) f_x(x, mu, sigma),

where F_x is the cumulative distribution function and f_x is the probability
density function of normal distribution.

Both \code{prectnorm} and \code{qrectnorm} are returned for the lower
tail of the distribution.

All the functions are defined for non-negative values only.
}
\examples{
x <- drectnorm(c(-1000:1000)/200, 0, 1)
plot(c(-1000:1000)/200, x, type="l")

x <- prectnorm(c(-1000:1000)/200, 0, 1)
plot(c(-1000:1000)/200, x, type="l")

qrectnorm(c(0.025,0.975), 0, c(1,2))

x <- rrectnorm(1000, 0, 1)
hist(x)

}
\seealso{
\code{\link[greybox]{Distributions}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.com}
}
\keyword{distribution}
