% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_gfdata.R
\name{compare_gfdata}
\alias{compare_gfdata}
\title{Compare Preliminary and Finalized 'GreenFeed' Data}
\arguments{
\item{prelimrep}{a data frame with preliminary 'GreenFeed' data}

\item{finalrep}{a data frame with finalized 'GreenFeed' data}

\item{start_date}{a character string representing the start date of the study (format: "DD-MM-YY" or "YYYY-MM-DD")}

\item{end_date}{a character string representing the end date of the study (format: "DD-MM-YY" or "YYYY-MM-DD")}
}
\value{
Data frame including records removed from preliminary and final reports
}
\description{
Compare preliminary and finalized 'GreenFeed' data.
}
\examples{
# Datasets with preliminary and finalized GreenFeed data
prelimrep <- system.file("extdata", "StudyName_GFdata.csv", package = "greenfeedr")
finalrep <- system.file("extdata", "StudyName_FinalReport.xlsx", package = "greenfeedr")

data <- compare_gfdata(
  prelimrep,
  finalrep,
  start_date = "2024-05-13",
  end_date = "2024-05-20"
)

}
