% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth-estimates.R
\name{spline_values}
\alias{spline_values}
\title{Evaluate a spline at provided covariate values}
\usage{
spline_values(
  smooth,
  data,
  model,
  unconditional,
  overall_uncertainty = TRUE,
  frequentist = FALSE
)
}
\arguments{
\item{smooth}{currently an object that inherits from class \code{mgcv.smooth}.}

\item{data}{a data frame of values to evaluate \code{smooth} at.}

\item{model}{a fitted model; currently only \code{\link[mgcv:gam]{mgcv::gam()}} and \code{\link[mgcv:bam]{mgcv::bam()}}
models are supported.}

\item{unconditional}{logical; should confidence intervals include the
uncertainty due to smoothness selection? If \code{TRUE}, the corrected Bayesian
covariance matrix will be used.}

\item{overall_uncertainty}{logical; should the uncertainty in the model
constant term be included in the standard error of the evaluate values of
the smooth?}

\item{frequentist}{logical; use the frequentist covariance matrix?}
}
\description{
Evaluate a spline at provided covariate values
}
