% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplers.R
\name{gaussian_draws}
\alias{gaussian_draws}
\alias{gaussian_draws.gam}
\alias{gaussian_draws.scam}
\title{Posterior samples using a simple Metropolis Hastings sampler}
\usage{
gaussian_draws(model, ...)

\method{gaussian_draws}{gam}(
  model,
  n,
  n_cores = 1L,
  index = NULL,
  frequentist = FALSE,
  unconditional = FALSE,
  mvn_method = "mvnfast",
  ...
)

\method{gaussian_draws}{scam}(
  model,
  n,
  n_cores = 1L,
  index = NULL,
  frequentist = FALSE,
  parametrized = TRUE,
  mvn_method = "mvnfast",
  ...
)
}
\arguments{
\item{model}{a fitted R model. Currently only models fitted by \code{mgcv::gam()}
or \code{mgcv::bam()}, or return an object that \emph{inherits} from such objects are
supported. Here, "inherits" is used in a loose fashion; models fitted by
\code{scam::scam()} are support even though those models don't strictly inherit
from class \code{"gam"} as far as \code{inherits()} is concerned.}

\item{...}{arguments passed to methods.}

\item{n}{numeric; the number of posterior draws to take.}

\item{n_cores}{integer; number of CPU cores to use when generating
multivariate normal distributed random values. Only used if
\code{mvn_method = "mvnfast"} \strong{and} \code{method = "gaussian"}.}

\item{index}{numeric; vector of indices of coefficients to use. Can be used
to subset the mean vector and covariance matrix extracted from \code{model}.}

\item{frequentist}{logical; if \code{TRUE}, the frequentist covariance matrix of
the parameter estimates is used. If \code{FALSE}, the Bayesian posterior
covariance matrix of the parameters is used. See \code{mgcv::vcov.gam()}.}

\item{unconditional}{logical; if \code{TRUE}  the Bayesian smoothing parameter
uncertainty corrected covariance matrix is used, \emph{if available} for
\code{model}. See \code{mgcv::vcov.gam()}.}

\item{mvn_method}{character; one of \code{"mvnfast"} or \code{"mgcv"}. The default is
uses \code{mvnfast::rmvn()}, which can be considerably faster at generate large
numbers of MVN random values than \code{mgcv::rmvn()}, but which might not work
for some marginal fits, such as those where the covariance matrix is close
to singular.}

\item{parametrized}{logical; use parametrized coefficients and covariance
matrix, which respect the linear inequality constraints of the model. Only
for \code{scam::scam()} model fits.}
}
\description{
Posterior samples using a simple Metropolis Hastings sampler
}
