% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utililties.R
\name{smooth_label}
\alias{smooth_label}
\alias{smooth_label.gam}
\alias{smooth_label.mgcv.smooth}
\title{Extract the label for a smooth used by 'mgcv'}
\usage{
smooth_label(object, ...)

\method{smooth_label}{gam}(object, id, ...)

\method{smooth_label}{mgcv.smooth}(object, ...)
}
\arguments{
\item{object}{an R object. Currently, methods for class \code{"gam"} and for mgcv
smooth objects inheriting from class \code{"mgcv.smooth"} are supported.}

\item{...}{arguments passed to other methods.}

\item{id}{numeric; the indices of the smooths whose labels are to be
extracted. If missing, labels for all smooths in the model are returned.}
}
\value{
A character vector.
}
\description{
The label 'mgcv' uses for smooths is useful in many contexts, including
selecting smooths or labelling plots. \code{smooth_label()} extracts this label
from an 'mgcv' smooth object, i.e. an object that inherits from class
\code{"mgcv.smooth"}. These would typically be found in the \verb{$smooth} component of
a GAM fitted by \code{\link[mgcv:gam]{mgcv::gam()}} or \code{\link[mgcv:bam]{mgcv::bam()}}, or related functions.
}
\examples{
load_mgcv()
df <- data_sim("gwf2", n = 100)
m <- gam(y ~ s(x), data = df, method = "REML")

# extract the smooth
sm <- get_smooths_by_id(m, id = 1)[[1]]

# extract the label
smooth_label(sm)

# or directly on the fitted GAM
smooth_label(m$smooth[[1]])

# or extract labels by idex/position
smooth_label(m, id = 1)
}
