% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_RFID_Validity_Study.R
\docType{data}
\name{RFID_Validity_Study}
\alias{RFID_Validity_Study}
\alias{rfid}
\alias{video}
\alias{known.before}
\alias{participants}
\title{RFID Validity dataset}
\format{
3 dataframes: \cr
\itemize{
\item participants (11 rows, 7 columns): attributes of the experiment's participants\cr
\item rfid (1011 rows, 4 columns): dyadic interactions detected by the RFID badges (after data processing)\cr
\item video (219 rows, 4 columns): dyadic interactions detected by the video rating\cr
and one network:\cr
\item known.before (11 rows, 11 columns): network of previous acquaintances\cr
See below for variables and formats.\cr
}

\tabular{lll}{
\strong{Object} \tab \strong{Description} \tab \strong{Format} \cr
participants$actor   \tab  Identifier of the actor                      \tab  integer        \cr
participants$label   \tab  (Anonymized) name                            \tab  Factor         \cr
participants$present \tab  Presence of the actor (all actors are present) \tab  logical      \cr
participants$age     \tab  Actor's age                                  \tab  integer        \cr
participants$gender  \tab  Actor's gender (0: male, 1: female)          \tab  integer        \cr
participants$group   \tab  Actor's group affiliation (groups have distinct ids) \tab  integer \cr
participants$level   \tab  Actor's seniority (1: MSc student, 2: PhD student, 3: PostDoc, 4: Prof)
\tab  integer        \cr
rfid$NodeA      \tab  Identifier for the first actor                    \tab  chr            \cr
rfid$NodeB      \tab  Identifier for the second actor                   \tab  chr            \cr
rfid$Start      \tab  Time of the beginning of the dyadic interaction   \tab  integer        \cr
rfid$End        \tab  Time of the end of the dyadic interaction         \tab  integer        \cr
video$NodeA     \tab  Identifier for the first actor                    \tab  chr            \cr
video$NodeB     \tab  Identifier for the second actor                   \tab  chr            \cr
video$Start     \tab  Time of the beginning of the dyadic interaction   \tab  integer        \cr
video$End       \tab  Time of the end of the dyadic interaction         \tab  integer        \cr
}

An object of class \code{data.frame} with 1011 rows and 4 columns.

An object of class \code{data.frame} with 219 rows and 4 columns.

An object of class \code{matrix} (inherits from \code{array}) with 11 rows and 11 columns.

An object of class \code{data.frame} with 11 rows and 7 columns.
}
\source{
\url{https://osf.io/rrhxe/}
}
\usage{
data(RFID_Validity_Study)

rfid

video

known.before

participants
}
\description{
Dataset collected at ETH Zürich by Timon Elmer and colleagues in order to
test the accuracy of Radio Frequency Identification (RFID) badges for
measuring social interactions.
Social interactions of 11 individuals (from the university staff) were
recorded with RFID badges in an informal setting. They were then compared to
the interactions observed by two confederates who watched the video recording
of the event. The RFID data went through the data processing procedure
detailed in the original article. See Elmer et al, 2019 for more details,
and the OSF platform for all details on the dataset.
}
\references{
Elmer, T., Chaitanya, K., Purwar, P., & Stadtfeld, C. (2019).
The validity of RFID badges measuring face-to-face interactions.
Behavior research methods, 1-19. \doi{10.3758/s13428-018-1180-y}
}
\keyword{RFID}
\keyword{datasets}
\keyword{interactions}
\keyword{social}
\keyword{study}
\keyword{validity}
