% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMVARconstruction.R
\name{update_numtols}
\alias{update_numtols}
\title{Update the stationarity and positive definiteness numerical tolerances of an
  existing class 'gmvar' model.}
\usage{
update_numtols(gmvar, stat_tol = 0.001, posdef_tol = 1e-08)
}
\arguments{
\item{gmvar}{an object of class \code{'gmvar'} created with \code{fitGMVAR} or \code{GMVAR}.}

\item{stat_tol}{numerical tolerance for stationarity of the AR parameters: if the "bold A" matrix of any regime
has eigenvalues larger that \code{1 - stat_tol} the model is classified as non-stationary. Note that if the
tolerance is too small, numerical evaluation of the log-likelihood might fail and cause error.}

\item{posdef_tol}{numerical tolerance for positive definiteness of the error term covariance matrices: if
the error term covariance matrix of any regime has eigenvalues smaller than this, the model is classified
as not satisfying positive definiteness assumption. Note that if the tolerance is too small, numerical
evaluation of the log-likelihood might fail and cause error.}
}
\value{
Returns an object of class \code{'gmvar'} defining a structural GMVAR model with the modified
  structural parameters and constraints.
}
\description{
\code{update_numtols} updates the stationarity and positive definiteness
  numerical tolerances of an existing class 'gmvar' model.
}
\details{
All signs in any column of \eqn{W} can be swapped without changing the implied reduced form model.
  Consequently, also the signs in the columns of the B-matrix are swapped. Note that the sign constraints
  imposed on \eqn{W} (or the B-matrix) are also swapped in the corresponding columns accordingly.

  Also the order of the columns of \eqn{W} can be changed (without changing the implied reduced
  form model) as long as the order of lambda parameters is also changed accordingly. This can be
  done with the function \code{reorder_W_columns}.
}
\examples{
# Structural GMVAR(2, 2), d=2 model identified with sign-constraints:
params22s <- c(0.36, 0.121, 0.484, 0.072, 0.223, 0.059, -0.151, 0.395,
  0.406, -0.005, 0.083, 0.299, 0.218, 0.02, -0.119, 0.722, 0.093, 0.032,
  0.044, 0.191, 0.057, 0.172, -0.46, 0.016, 3.518, 5.154, 0.58)
W_22 <- matrix(c(1, 1, -1, 1), nrow=2, byrow=FALSE)
mod22s <- GMVAR(p=2, M=2, d=2, params=params22s, structural_pars=list(W=W_22))
mod22s

# Update numerical tolerances:
mod22s <- update_numtols(mod22s, stat_tol=1e-4, posdef_tol=1e-9)
mod22s # The same model
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
 @keywords internal
}
\seealso{
\code{\link{fitGMVAR}}, \code{\link{GMVAR}}, \code{\link{GIRF}}, \code{\link{reorder_W_columns}},
 \code{\link{gmvar_to_sgmvar}}
}
