% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{bread.glmmTMB}
\alias{bread.glmmTMB}
\alias{bread}
\title{Bread Matrix for Sandwich Estimator}
\usage{
\method{bread}{glmmTMB}(x, full = FALSE, rawnames = FALSE, ...)
}
\arguments{
\item{x}{a fitted \code{glmmTMB} object.}

\item{full}{return a full variance-covariance matrix?}

\item{rawnames}{logical; if \code{TRUE}, return the raw names of the parameters as in the \code{TMB} object.
By default, \code{FALSE} such that the names are sanitized to user friendly names.}

\item{...}{ignored additional arguments (only for methods compatibility).}
}
\value{
The bread matrix, which is just the variance-covariance matrix.
}
\description{
This method for \code{\link[sandwich]{bread}} returns the variance-covariance
matrix (bread) for a fitted \code{glmmTMB} model.
}
\examples{
m <- glmmTMB(count ~ mined + (1 | spp), data = Salamanders, family = nbinom1)
bread(m)
bread(m, full = TRUE)
}
