% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maPlot.R
\name{maPlot}
\alias{maPlot}
\title{MA plots}
\usage{
maPlot(
  glmmResult,
  x1Label,
  x2Label,
  x1Values = NULL,
  x2Values = NULL,
  pCutoff = 0.01,
  plotCutoff = 1,
  zeroCountCutoff = 50,
  colours = c("grey", "midnightblue", "mediumvioletred", "goldenrod"),
  labels = c(),
  fontSize = 12,
  labelFontSize = 5,
  useAdjusted = FALSE,
  graphics = "ggplot",
  verbose = FALSE
)
}
\arguments{
\item{glmmResult}{A glmmSeq object created by
\code{\link[glmmSeq:glmmSeq]{glmmSeq::glmmSeq()}}.}

\item{x1Label}{The name of the first (inner) x parameter}

\item{x2Label}{The name of the second (outer) x parameter}

\item{x1Values}{Subpopulations in x1Label to be used to calculate fold
change. If NULL the first two levels in x1Label are used.}

\item{x2Values}{Subpopulations in x2Label to be compared on x and y axis.}

\item{pCutoff}{The significance cut-off for colour-coding (default=0.01)}

\item{plotCutoff}{Which probes to include by significance cut-off
(default=1 for all markers)}

\item{zeroCountCutoff}{Which probes to include by minimum counts cut-off
(default = 50)}

\item{colours}{Vector of colours to use for significance groups}

\item{labels}{Row names or indices to label on plot}

\item{fontSize}{Font size}

\item{labelFontSize}{Font size for labels}

\item{useAdjusted}{whether to use adjusted pvalues
(must have q_ columns in glmmResult)}

\item{graphics}{Either "ggplot" or "plotly"}

\item{verbose}{Whether to print statistics}
}
\value{
List of three plots. One plot for each x2Value and one combined
figure
}
\description{
MA plots
}
\examples{
data(PEAC_minimal_load)

disp <- apply(tpm, 1, function(x){
(var(x, na.rm=TRUE)-mean(x, na.rm=TRUE))/(mean(x, na.rm=TRUE)**2)
})

resultTable <- glmmSeq(~ Timepoint * EULAR_6m + (1 | PATID),
                       id = "PATID",
                       countdata = tpm[1:5, ],
                       metadata = metadata,
                       dispersion = disp)

plots <- maPlot(resultTable,
                x1Label='Timepoint',
                x2Label='EULAR_6m',
                x2Values=c('Good responder', 'Non responder'),
                graphics="plotly")

plots$combined
}
\keyword{hplot}
