% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_git_ok.R
\name{tar_git_ok}
\alias{tar_git_ok}
\title{Check Git}
\usage{
tar_git_ok(verbose = TRUE)
}
\arguments{
\item{verbose}{Whether to print messages to the console.}
}
\value{
Logical of length 1, whether Git is installed and configured
correctly.
}
\description{
Check if Git is installed and if \code{user.name} and \code{user.email}
are configured globally.
}
\details{
You can install Git from \url{https://git-scm.com/downloads/}
and configure your identity using the instructions at
\url{https://git-scm.com/book/en/v2/Getting-Started-First-Time-Git-Setup}.
You may find it convenient to run \code{gert::git_config_global()}
with \code{name} equal to \code{user.name} and \code{user.email}.
}
\examples{
if (Sys.getenv("TAR_EXAMPLES") == "true") {
tar_git_ok()
}
}
\seealso{
Other git: 
\code{\link{tar_git_checkout}()},
\code{\link{tar_git_init}()},
\code{\link{tar_git_log}()},
\code{\link{tar_git_snapshot}()},
\code{\link{tar_git_status_code}()},
\code{\link{tar_git_status_data}()},
\code{\link{tar_git_status_targets}()},
\code{\link{tar_git_status}()}
}
\concept{git}
