% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gglist.R, R/ggtibble.R
\name{knit_print.gglist}
\alias{knit_print.gglist}
\alias{knit_print.ggtibble}
\title{Print a list of plots made by gglist}
\usage{
\method{knit_print}{gglist}(x, ..., filename = NULL, fig_suffix = "\\n\\n")

\method{knit_print}{ggtibble}(x, ...)
}
\arguments{
\item{x}{The gglist object}

\item{...}{extra arguments to \code{knit_print()}}

\item{filename}{A filename with an optional "\%d" sprintf pattern for saving
the plots}

\item{fig_suffix}{Any text to add after the figure}
}
\value{
The list, invisibly
}
\description{
The \code{filename} argument may be given with an \code{sprintf()} format including
"\%d" to allow automatic numbering of the output filenames.  Specifically, the
pattern of "\%d" with an optional non-negative integer between the "\%" and "d"
is searched for and if found, then the filename will be generated using that
\code{sprintf()} format.  Note that also means that other requirements for
\code{sprintf()} must be met; for example, if you want a percent sign ("\%") in the
filename, it must be doubled so that sprintf returns what is desired.
}
\section{Functions}{
\itemize{
\item \code{knit_print(ggtibble)}: Print the plots in a \code{ggtibble} object

}}
\examples{
# Ensure that each figure is within its own float area
mydata <-
  list(
    data.frame(x = 1:3, y = 3:1),
    data.frame(x = 4:7, y = 7:4)
  )
p <- gglist(mydata, ggplot2::aes(x = x, y = y)) +
  ggplot2::geom_point()
knit_print(p, fig_suffix = "\n\n\\\\FloatBarrier\n\n")
}
\seealso{
Other knitters: 
\code{\link{knit_print.gg}()}
}
\concept{knitters}
