% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-density-line.R
\docType{data}
\name{geom_density_line}
\alias{geom_density_line}
\alias{GeomDensityLine}
\title{Smoothed density estimates drawn with a ridgeline rather than area}
\usage{
geom_density_line(mapping = NULL, data = NULL, stat = "density",
  position = "identity", ..., na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}
}
\description{
This function is a drop-in replacement for ggplot2's \code{\link[=geom_density]{geom_density()}}. The only difference is that
the geom draws a ridgeline (line with filled area underneath) rather than a polygon.
}
\examples{
library(ggplot2)
ggplot(diamonds, aes(carat)) +
  geom_density_line()

ggplot(diamonds, aes(carat)) +
  geom_density_line(adjust = 1/5)
ggplot(diamonds, aes(carat)) +
  geom_density_line(adjust = 5)

ggplot(diamonds, aes(depth, colour = cut)) +
  geom_density_line(alpha = 0.5) +
  xlim(55, 70)
ggplot(diamonds, aes(depth, fill = cut, colour = cut)) +
  geom_density_line(alpha = 0.1) +
  xlim(55, 70)
}
\seealso{
See \code{\link[=geom_density]{geom_density()}}.
}
\keyword{datasets}
