% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsummarystats.R
\name{ggsummarytable}
\alias{ggsummarytable}
\alias{ggsummarystats}
\alias{print.ggsummarystats}
\alias{print.ggsummarystats_list}
\title{GGPLOT with Summary Stats Table Under the Plot}
\usage{
ggsummarytable(
  data,
  x,
  y,
  digits = 0,
  size = 3,
  color = "black",
  palette = NULL,
  facet.by = NULL,
  labeller = "label_value",
  position = "identity",
  ggtheme = theme_pubr(),
  ...
)

ggsummarystats(
  data,
  x,
  y,
  summaries = c("n", "median", "iqr"),
  ggfunc = ggboxplot,
  color = "black",
  fill = "white",
  palette = NULL,
  facet.by = NULL,
  free.panels = FALSE,
  labeller = "label_value",
  heights = c(0.8, 0.2),
  ggtheme = theme_pubr(),
  ...
)

\method{print}{ggsummarystats}(x, heights = c(0.8, 0.2), ...)

\method{print}{ggsummarystats_list}(x, heights = c(0.8, 0.2), legend = NULL, ...)
}
\arguments{
\item{data}{a data frame}

\item{x}{a list of \code{ggsummarystats}.}

\item{y}{character vector containing one or more variables to plot}

\item{digits}{integer indicating the number of decimal places (round) to be
used.}

\item{size}{Numeric value (e.g.: size = 1). change the size of points and
outlines.}

\item{color}{outline color.}

\item{palette}{the color palette to be used for coloring or filling by groups.
Allowed values include "grey" for grey color palettes; brewer palettes e.g.
"RdBu", "Blues", ...; or custom color palette e.g. c("blue", "red"); and
scientific journal palettes from ggsci R package, e.g.: "npg", "aaas",
"lancet", "jco", "ucscgb", "uchicago", "simpsons" and "rickandmorty".}

\item{facet.by}{character vector, of length 1 or 2, specifying grouping
variables for faceting the plot into multiple panels. Should be in the data.}

\item{labeller}{Character vector. An alternative to the argument
\code{short.panel.labs}. Possible values are one of "label_both" (panel
labelled by both grouping variable names and levels) and "label_value"
(panel labelled with only grouping levels).}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{ggtheme}{function, ggplot2 theme name. Default value is theme_pubr().
Allowed values include ggplot2 official themes: theme_gray(), theme_bw(),
theme_minimal(), theme_classic(), theme_void(), ....}

\item{...}{other arguments passed to the function \code{\link{ggpar}()},
\code{\link{facet}()} or \code{\link{ggarrange}()} when printing the plot.}

\item{summaries}{summary stats to display in the table. Possible values are
those returned by the function \code{\link[rstatix]{get_summary_stats}()},
including: \code{"n", "min", "max",  "median",  "q1", "q2", "q3", "mad",
"mean", "sd", "se", "ci"}.}

\item{ggfunc}{a ggpubr function, including: ggboxplot, ggviolin, ggdotplot,
ggbarplot, ggline, etc. Can be any other ggplot function that accepts the
following arguments \code{data, x, color, fill, palette, ggtheme,
facet.by}.}

\item{fill}{fill color.}

\item{free.panels}{logical. If TRUE, create free plot panels when the
argument \code{facet.by} is specified.}

\item{heights}{a numeric vector of length 2, specifying the heights of the
main and the summary table, respectively.}

\item{legend}{character specifying legend position. Allowed values are one of
c("top", "bottom", "left", "right", "none"). To remove the legend use
legend = "none".}
}
\description{
Create a ggplot with summary stats (n, median, mean, iqr) table
  under the plot.
}
\section{Functions}{
\itemize{
\item \code{ggsummarytable}: Create a table of summary stats

\item \code{ggsummarystats}: Create a ggplot with a summary stat table under the plot.
}}

\examples{
# Data preparation
#::::::::::::::::::::::::::::::::::::::::::::::::
data("ToothGrowth")
df <- ToothGrowth
df$dose <- as.factor(df$dose)
# Add random QC column
set.seed(123)
qc <- rep(c("pass", "fail"), 30)
df$qc <- as.factor(sample(qc, 60))
# Inspect the data
head(df)


# Basic summary stats
#::::::::::::::::::::::::::::::::::::::::::::::::
# Compute summary statistics
summary.stats <- df \%>\%
  group_by(dose) \%>\%
  get_summary_stats(type = "common")
summary.stats

# Visualize summary table
ggsummarytable(
  summary.stats, x = "dose", y = c("n", "median", "iqr"),
  ggtheme = theme_bw()
)


# Create plots with summary table under the plot
#::::::::::::::::::::::::::::::::::::::::::::::::
# Basic plot
ggsummarystats(
  df, x = "dose", y = "len",
  ggfunc = ggboxplot, add = "jitter"
)

# Color by groups
ggsummarystats(
  df, x = "dose", y = "len",
  ggfunc = ggboxplot, add = "jitter",
  color = "dose", palette = "npg"
)

# Create a barplot
ggsummarystats(
  df, x = "dose", y = "len",
  ggfunc = ggbarplot, add = c("jitter", "median_iqr"),
  color = "dose", palette = "npg"
)

# Facet
#::::::::::::::::::::::::::::::::::::::::::::::::

ggsummarystats(
  df, x = "dose", y = "len",
  ggfunc = ggboxplot, add = "jitter",
  color = "dose", palette = "npg",
  facet.by = c("supp", "qc")
)
 # Specify labeller
ggsummarystats(
  df, x = "dose", y = "len",
  ggfunc = ggboxplot, add = "jitter",
  color = "dose", palette = "npg",
  facet.by = c("supp", "qc"),
  labeller = "label_both"
)

# Free panels
ggsummarystats(
  df, x = "dose", y = "len",
  ggfunc = ggboxplot, add = "jitter",
  color = "dose", palette = "npg",
  facet.by = c("supp", "qc"),
  free.panels = TRUE, labeller = "label_both"
)

}
